/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing;

import ch.tatool.core.display.swing.SwingExecutionDisplay;
import ch.tatool.core.display.swing.SwingExecutionFrame;
import ch.tatool.core.display.swing.container.ContainerUtils;
import ch.tatool.data.Module;
import ch.tatool.display.ExecutionDisplayProvider;
import ch.tatool.exec.ExecutionPhase;
import ch.tatool.exec.ExecutionPhaseListener;
import ch.tatool.exec.Executor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingExecutionDisplayProvider
implements ExecutionDisplayProvider {
    Logger logger = LoggerFactory.getLogger(SwingExecutionDisplayProvider.class);
    public static final String PROPERTY_DISPLAY_MODE = "module.execution.display.mode";
    public static final String DISPLAY_MODE_FULLSCREEN = "fullscreen";
    public static final String DISPLAY_MODE_WINDOW = "frame";
    public static final String PROPERTY_INITIALIZE_REGIONS_CONTAINER = "module.execution.display.regionsContainer";
    private WindowClosingListener windowClosingListener;
    private SwingExecutionFrame executionDisplay = new SwingExecutionFrame();
    private Executor executor;

    public SwingExecutionDisplayProvider() {
        this.windowClosingListener = new WindowClosingListener();
        this.executionDisplay.addWindowListener(this.windowClosingListener);
        this.executionDisplay.getRootPane().setFocusable(true);
    }

    public SwingExecutionDisplay getExecutionDisplay() {
        return this.executionDisplay;
    }

    public void setup(Executor executor, Module module) {
        String regContainer;
        this.executor = executor;
        this.executionDisplay.setExecutor(this.executor);
        this.executor.getPhaseListenerManager().addExecutionPhaseListener((ExecutionPhaseListener)this.executionDisplay, ExecutionPhase.POST_ELEMENT_SELECTION);
        String mode = (String)module.getModuleProperties().get(PROPERTY_DISPLAY_MODE);
        if (DISPLAY_MODE_WINDOW.equals(mode)) {
            this.executionDisplay.setFullScreenModeEnabled(false);
        }
        if (Boolean.parseBoolean(regContainer = (String)module.getModuleProperties().get(PROPERTY_INITIALIZE_REGIONS_CONTAINER))) {
            ContainerUtils.initialize(this.executionDisplay);
        }
    }

    public void open() {
        this.executionDisplay.showWindow();
    }

    public void destroy() {
        this.executionDisplay.disposeWindow();
    }

    public void stopModuleExecution() {
        if (this.executor != null) {
            this.executor.stopExecution();
        }
    }

    class WindowClosingListener
    extends WindowAdapter {
        WindowClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent we) {
            SwingExecutionDisplayProvider.this.stopModuleExecution();
        }
    }
}

