/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.data;

import ch.tatool.core.data.ObjectProperty;
import ch.tatool.core.data.StringConverter;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Property;
import ch.tatool.data.PropertyHolder;
import ch.tatool.element.Node;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericProperty<T>
implements Property<T> {
    private static Logger logger = LoggerFactory.getLogger(ObjectProperty.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String propertyName;
    private Class<T> propertyType;

    public GenericProperty(String propertyName, Class<T> propertyType) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean isSet(PropertyHolder holder) {
        return holder.getProperty(this.propertyName) != null;
    }

    public boolean isSet(DataContainer dataContainer, PropertyHolder propertyHolder) {
        return this.isSet(dataContainer, propertyHolder.getId());
    }

    public boolean isSet(DataContainer dataContainer, String nodeId) {
        return dataContainer.getValue(nodeId, this.propertyName) != null;
    }

    public T getValue(PropertyHolder holder) {
        return this.getValue(holder, null);
    }

    public T getValue(PropertyHolder holder, T defaultValue) {
        Object value = holder.getProperty(this.propertyName);
        if (value != null) {
            if (this.propertyType.isInstance(value)) {
                return (T)value;
            }
            logger.warn("Invalid property value for property " + this.propertyName + ". Type " + this.propertyType.getName() + " expected, but passed value of type " + value.getClass());
        }
        return defaultValue;
    }

    public String getStringValue(DataContainer dataContainer, PropertyHolder holder) {
        return this.getStringValue(dataContainer, holder.getId(), null);
    }

    public String getStringValue(DataContainer dataContainer, String nodeId) {
        return this.getStringValue(dataContainer, nodeId, null);
    }

    public String getStringValue(DataContainer dataContainer, PropertyHolder holder, String defaultValue) {
        return this.getStringValue(dataContainer, holder.getId(), defaultValue);
    }

    public String getStringValue(DataContainer dataContainer, String nodeId, String defaultValue) {
        String value = dataContainer.getValue(nodeId, this.propertyName);
        return value != null ? value : defaultValue;
    }

    public void setValue(PropertyHolder holder, T value) {
        holder.setProperty(this.propertyName, value);
    }

    public void setValue(DataContainer dataContainer, PropertyHolder holder) {
        T value = this.getValue(holder);
        this.setValue(dataContainer, holder, value);
    }

    public void setValue(DataContainer dataContainer, PropertyHolder holder, T value) {
        this.setValue(dataContainer, holder.getId(), value);
    }

    public void setValue(DataContainer dataContainer, String nodeId, T value) {
        if (value != null) {
            if (value instanceof Date) {
                this.setStringValue(dataContainer, nodeId, this.dateFormat.format(value));
            } else {
                this.setStringValue(dataContainer, nodeId, value.toString());
            }
        } else {
            this.setStringValue(dataContainer, nodeId, (String)null);
        }
    }

    public void setStringValue(DataContainer dataContainer, PropertyHolder holder, String value) {
        this.setStringValue(dataContainer, holder.getId(), value);
    }

    public void setStringValue(DataContainer dataContainer, String nodeId, String value) {
        dataContainer.putValue(nodeId, this.propertyName, value);
    }

    public void clearValue(PropertyHolder holder) {
        holder.setProperty(this.propertyName, null);
    }

    public void clearValue(DataContainer dataContainer, PropertyHolder holder) {
        this.clearValue(dataContainer, holder.getId());
    }

    public void clearValue(DataContainer dataContainer, String nodeId) {
        dataContainer.putValue(nodeId, this.propertyName, null);
    }

    public T getValue(DataContainer dataContainer, PropertyHolder holder) {
        return this.getValue(dataContainer, holder.getId(), null);
    }

    public T getValue(DataContainer dataContainer, String nodeId) {
        return this.getValue(dataContainer, nodeId, null);
    }

    public T getValue(DataContainer dataContainer, PropertyHolder holder, T defaultValue) {
        return this.getValue(dataContainer, holder.getId(), defaultValue);
    }

    public T getValue(DataContainer dataContainer, String nodeId, T defaultValue) {
        if (!StringConverter.containsConverter(this.propertyType)) {
            throw new UnsupportedOperationException("No converter for class " + this.propertyType.getName() + " available.");
        }
        String value = this.getStringValue(dataContainer, nodeId);
        if (value != null) {
            return (T)StringConverter.convert(value, this.propertyType);
        }
        return defaultValue;
    }

    public void restoreValue(DataContainer dataContainer, PropertyHolder holder) {
        this.restoreValue(dataContainer, holder, null);
    }

    public void restoreValue(DataContainer dataContainer, PropertyHolder holder, T defaultValue) {
        T value = this.getValue(dataContainer, holder, defaultValue);
        this.setValue(holder, value);
    }

    public T ensureValue(DataContainer dataContainer, PropertyHolder holder) {
        return this.ensureValue(dataContainer, holder.getId());
    }

    public T ensureValue(DataContainer dataContainer, String nodeId) {
        throw new UnsupportedOperationException();
    }

    public T ensureValue(DataContainer dataContainer, PropertyHolder holder, T defaultValue) {
        return this.ensureValue(dataContainer, holder.getId(), defaultValue);
    }

    public T ensureValue(DataContainer dataContainer, String nodeId, T defaultValue) {
        T value = this.getValue(dataContainer, nodeId);
        if (value == null) {
            this.setValue(dataContainer, nodeId, defaultValue);
            return defaultValue;
        }
        return value;
    }

    public boolean copyValue(DataContainer dataContainer, Node fromNode, Node toNode, T defaultValue) {
        return this.copyValue(dataContainer, fromNode.getId(), toNode.getId(), defaultValue);
    }

    public boolean copyValue(DataContainer dataContainer, String fromId, String toId, T defaultValue) {
        String value = this.getStringValue(dataContainer, fromId, null);
        if (value != null) {
            this.setStringValue(dataContainer, toId, value);
            return true;
        }
        if (defaultValue != null) {
            this.setValue(dataContainer, toId, defaultValue);
            return true;
        }
        return false;
    }
}

