/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ProgressDialog.java
 *
 * Created on 11.04.2010, 15:57:56
 */

package ch.tatool.core.module.creator;

import java.awt.Image;

/**
 *
 * @author Michael Ruflin
 */
public class ProgressDialog extends javax.swing.JDialog {

	private static final long serialVersionUID = 1552712738457326859L;
	
	/** Creates new form ProgressDialog */
    public ProgressDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(null);
        java.net.URL iconUrl = this.getClass().getResource("/ch/tatool/app/gui/icon.png");
		Image icon = getToolkit().getImage(iconUrl); 
		setIconImage(icon);
    }

    public void setMinimum(int min) {
        progressBar.setMinimum(min);
    }
    public void setMaximum(int max) {
        progressBar.setMaximum(max);
    }
    public void setValue(int value) {
        progressBar.setValue(value);
    }
    public void setIndeterminate(boolean indeterminate) {
        progressBar.setIndeterminate(indeterminate);
    }
    public void setLabel(String label) {
        statusLabel.setText(label);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        progressBar = new javax.swing.JProgressBar();
        statusLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Tatool");

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(20, 40, 20, 40));
        jPanel1.setLayout(new java.awt.BorderLayout(10, 10));

        progressBar.setIndeterminate(true);
        jPanel1.add(progressBar, java.awt.BorderLayout.CENTER);

        jPanel1.add(statusLabel, java.awt.BorderLayout.PAGE_START);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                ProgressDialog dialog = new ProgressDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JLabel statusLabel;
    // End of variables declaration//GEN-END:variables

}
