/*******************************************************************************
 * Copyright (c) 2011 Michael Ruflin, Andr Locher, Claudia von Bastian.
 * 
 * This file is part of Tatool.
 * 
 * Tatool is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published 
 * by the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * Tatool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Tatool. If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ch.tatool.core.display.swing.action;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.GroupLayout.Alignment;
import javax.swing.LayoutStyle.ComponentPlacement;

/**
 * Panel that provides a submit button and an optional description label.
 * The default submitted actionValue is null, but can be changed through a setter.
 *
 * @author Michael Ruflin
 */
public class ListActionPanel extends AbstractActionPanel {

	private static final long serialVersionUID = -6768844783262584074L;

	/** Is this action panel enabled. */
	private boolean enabled;
	
	/** ActionValue provided upon submission. */
	private Object actionValue;

        /** Holds the list elements. */
        private DefaultListModel listModel;
	
	/** KeyEventDispatcher */
	private SubmitKeyEventDispatcher keyEventDispatcher; 
	
	/** Creates new form SubmitActionPanel */
    public ListActionPanel() {
        listModel = new DefaultListModel();
        initComponents();
        
        keyEventDispatcher = new SubmitKeyEventDispatcher();
        
        // default actionValue
        actionValue = null;
    }

    /** Get the label of the left button. */
    public void setButtonText(String label) {
	submitButton.setText(label);
    }

    public void addListEntry(Object o) {
        listModel.addElement(o);
    }

    public Object getListEntry(int index) {
        return listModel.getElementAt(index);
    }

    public void clearList() {
        listModel.removeAllElements();
    }

    public Object getActionValue() {
		return actionValue;
	}

	public void setActionValue(Object actionValue) {
		this.actionValue = actionValue;
	}
	
	public void enableActionPanel() {
	    enabled = true;
        answerList.setSelectedIndex(0);
        answerList.ensureIndexIsVisible(0);
        answerList.requestFocusInWindow();
        // register the key dispatcher
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEventDispatcher);
	}
	
	public void disableActionPanel() {
	    enabled = false;
	    
        // register the key dispatcher
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(keyEventDispatcher);
	}

	/** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        answerList = new JList();
        submitButton = new JButton();

        setPreferredSize(new Dimension(323, 360));

        jPanel2.setOpaque(false);

        answerList.setFont(answerList.getFont().deriveFont(answerList.getFont().getSize()+8f));
        answerList.setModel(listModel);
        answerList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        answerList.setVisibleRowCount(10);
        answerList.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent evt) {
                answerListMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(answerList);

        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(Alignment.LEADING)
            .addComponent(jScrollPane1, Alignment.TRAILING, GroupLayout.DEFAULT_SIZE, 303, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(Alignment.LEADING)
            .addComponent(jScrollPane1, GroupLayout.DEFAULT_SIZE, 201, Short.MAX_VALUE)
        );

        submitButton.setFont(submitButton.getFont().deriveFont(submitButton.getFont().getSize()+10f));
        submitButton.setText("FINISHED");
        submitButton.setMargin(new Insets(8, 20, 8, 20));
        submitButton.setMaximumSize(new Dimension(0, 0));
        submitButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                submitButtonActionPerformed(evt);
            }
        });

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.TRAILING)
                    .addComponent(jPanel2, Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(submitButton, Alignment.LEADING, GroupLayout.DEFAULT_SIZE, 303, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(ComponentPlacement.UNRELATED)
                .addComponent(submitButton, GroupLayout.PREFERRED_SIZE, 43, GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void submitButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_submitButtonActionPerformed
        if (enabled) {
            if (answerList.getSelectedValue() == null) {
                setActionValue("");
            } else {
                setActionValue(answerList.getSelectedValue());
            }
            fireActionTriggered(actionValue);
        }
    }//GEN-LAST:event_submitButtonActionPerformed

    private void answerListMouseClicked(MouseEvent evt) {//GEN-FIRST:event_answerListMouseClicked
        if (evt.getClickCount() > 1) {
            fireActionTriggered(actionValue);
        }
    }//GEN-LAST:event_answerListMouseClicked


    // Variables declaration - do not modify//GEN-BEGIN:variables
    JList answerList;
    JButton submitButton;
    // End of variables declaration//GEN-END:variables

    
    /**
     * KeyListener that links some of the keyboard keys to the left and right choice buttons.
     */
    class SubmitKeyEventDispatcher implements KeyEventDispatcher {
        /** Called when a key has been typed. */
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == KeyEvent.KEY_PRESSED) {
                switch (e.getKeyCode()) {
                // Enter and space
                case KeyEvent.VK_ENTER:
                case KeyEvent.VK_SPACE:
                    submitButton.doClick();
                    break;
                }
            }
            
            // never consume the event...
            return false;
        }
    }
}
