/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.module.scheduler;

import ch.tatool.core.module.scheduler.AbstractModuleScheduler;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.module.ModuleSchedulerMessage;
import java.util.GregorianCalendar;

public class DailyModuleScheduler
extends AbstractModuleScheduler {
    public void initialize() {
    }

    public String getName() {
        return "DailyExecutionScheduler";
    }

    public boolean canUserTerminateSession(ModuleSession moduleSession) {
        return false;
    }

    public ModuleSchedulerMessage isSessionStartAllowed(Module module) {
        GregorianCalendar todayDate = new GregorianCalendar();
        todayDate.set(11, 0);
        todayDate.set(12, 0);
        todayDate.set(13, 0);
        todayDate.set(14, 0);
        GregorianCalendar lastSessionDate = new GregorianCalendar();
        long numSessions = this.getDataService().getSessionCount(module, false);
        ModuleSession lastSession = this.getDataService().getLastSession(module);
        if (lastSession != null && lastSession.getEndTime() != null) {
            lastSessionDate.setTime(lastSession.getStartTime());
        } else {
            lastSessionDate.set(1, 1900);
        }
        AbstractModuleScheduler.ModuleSchedulerMessageImpl message = new AbstractModuleScheduler.ModuleSchedulerMessageImpl();
        if (lastSessionDate.before(todayDate)) {
            message.setSessionStartAllowed(true);
            return message;
        }
        if (!lastSessionDate.before(todayDate)) {
            message.setSessionStartAllowed(false);
            message.setMessageTitle("Tatool");
            int hours = 23 - lastSessionDate.get(11);
            int minutes = 60 - lastSessionDate.get(12);
            StringBuilder mb = new StringBuilder();
            mb.append("Sie haben heute bereits eine Einheit absolviert.\n");
            mb.append("Dieses Modul erlaubt nur eine Einheit pro Tag.\n");
            mb.append("Sie k\u00f6nnen die n\u00e4chste Einheit in " + hours + " Stunden und " + minutes + " Minuten starten.");
            message.setMessageText(mb.toString());
            return message;
        }
        if (numSessions < 26L) {
            message.setSessionStartAllowed(false);
            message.setMessageTitle("Tatool");
            message.setMessageText("Sie d\u00fcrfen nur 26 Einheiten von diesem Modul absolvieren.");
            return message;
        }
        if (lastSessionDate.before(todayDate) && numSessions < 26L) {
            return message;
        }
        return message;
    }
}

