/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.module.creator;

import au.com.bytecode.opencsv.CSVReader;
import ch.tatool.core.data.StringProperty;
import ch.tatool.core.module.creator.CreationException;
import ch.tatool.core.module.creator.Worker;
import ch.tatool.core.module.initializer.SpringExecutorInitializer;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.data.UserAccount;
import ch.tatool.export.DataExporter;
import ch.tatool.module.ModuleService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleCreationWorker
implements Worker {
    Logger logger = LoggerFactory.getLogger(ModuleCreationWorker.class);
    private String errorTitle;
    private String errorText;
    private Module module;
    private Messages messages;

    public void createModule(ModuleService moduleService, UserAccount userAccount, File configurationFile, File moduleDataFile, String defaultModuleName, boolean failIfNameExists) {
        this.module = null;
        this.errorTitle = null;
        this.errorText = null;
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            HashMap<String, byte[]> binaryProperties = new HashMap<String, byte[]>();
            HashMap<String, DataExporter> moduleExporters = new HashMap<String, DataExporter>();
            SpringExecutorInitializer configuration = new SpringExecutorInitializer();
            configuration.loadModuleConfiguration(configurationFile, properties, binaryProperties, moduleExporters);
            String moduleName = (String)properties.get("module.name");
            if (moduleName == null) {
                if (defaultModuleName != null) {
                    moduleName = defaultModuleName;
                } else {
                    this.errorTitle = this.messages.getString("General.errorMessage.windowTitle.error");
                    this.errorText = this.messages.getString("General.creator.dataServerCreator.errorMessage.missingModuleName");
                    return;
                }
            }
            Set modules = moduleService.getModules(userAccount);
            boolean uniqueNameFound = false;
            String proposedName = moduleName;
            int x = 1;
            block3: do {
                for (Module.Info info : modules) {
                    String name = info.getName();
                    if (!name.equals(proposedName)) continue;
                    if (failIfNameExists) {
                        this.errorTitle = this.messages.getString("General.errorMessage.windowTitle.error");
                        this.errorText = this.messages.getString("General.creator.dataServerCreator.errorMessage.alreadyExists");
                        return;
                    }
                    proposedName = moduleName + " (" + x + ")";
                    ++x;
                    continue block3;
                }
                uniqueNameFound = true;
            } while (!uniqueNameFound);
            properties.put("module.name", proposedName);
            this.module = moduleService.createModule(userAccount, properties, binaryProperties, moduleExporters);
            this.loadModuleData(moduleService, moduleDataFile);
        }
        catch (CreationException ce) {
            this.logger.warn(ce.getMessage());
            this.errorTitle = "Error";
            this.errorText = "The following error occurred while trying to open the module file:\n" + ce.errorMessage;
        }
        catch (RuntimeException e) {
            this.logger.warn(e.getMessage());
            this.errorTitle = "Error";
            this.errorText = "An unknown error has occurred. Make sure the module file is correct.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModuleData(ModuleService moduleService, File moduleDataFile) {
        if (moduleDataFile != null) {
            List moduleData = new ArrayList();
            CSVReader reader = null;
            try {
                reader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(moduleDataFile), "ISO-8859-1"), ';');
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            try {
                moduleData = reader.readAll();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            for (int i = 0; i < moduleData.size(); ++i) {
                String[] data = (String[])moduleData.get(i);
                String nodeID = "";
                String propertyName = "";
                String propertyValue = "";
                nodeID = data[0] == null ? "" : data[0];
                propertyName = data[1] == null ? "" : data[1];
                propertyValue = data[2] == null ? "" : data[2];
                StringProperty dataProperty = new StringProperty(propertyName);
                dataProperty.setValue((DataContainer)this.module, nodeID, propertyValue);
            }
            moduleService.saveModule(this.module);
        }
    }

    @Override
    public boolean hasFinished() {
        return this.module != null;
    }

    @Override
    public String getErrorTitle() {
        return this.errorTitle;
    }

    public void setErrorTitle(String errorTitle) {
        this.errorTitle = errorTitle;
    }

    @Override
    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

