/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.module.creator;

import ch.tatool.core.module.creator.Worker;
import ch.tatool.data.Messages;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class FileDownloadWorker
implements Worker {
    private File file;
    private String errorTitle;
    private String errorText;
    private Messages messages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String url, int timeout) {
        BasicHttpParams params = new BasicHttpParams();
        if (timeout > 0) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        }
        url = url.replaceAll("\\s+", "").trim();
        DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)params);
        HttpGet httpGet = new HttpGet(url);
        this.errorTitle = null;
        this.errorText = null;
        this.file = null;
        try {
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                this.errorTitle = this.messages.getString("General.errorMessage.windowTitle.error");
                this.errorText = this.messages.getString("DataExportError.online.http");
                this.errorText = this.errorText + "\n" + response.getStatusLine().getReasonPhrase() + " (" + response.getStatusLine().getStatusCode() + ")";
            } else {
                HttpEntity entity = response.getEntity();
                byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
                File tmpFile = File.createTempFile("tatool_module", "tmp");
                FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])data);
                tmpFile.deleteOnExit();
                this.file = tmpFile;
            }
        }
        catch (IOException ioe) {
            this.errorTitle = this.messages.getString("General.errorMessage.windowTitle.error");
            this.errorText = this.messages.getString("DataExportError.online.http");
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    @Override
    public boolean hasFinished() {
        return this.file != null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String getErrorTitle() {
        return this.errorTitle;
    }

    public void setErrorTitle(String errorTitle) {
        this.errorTitle = errorTitle;
    }

    @Override
    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

