/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.executable;

import ch.tatool.core.display.swing.panel.CenteredTextPanel;
import ch.tatool.core.executable.ListInstructionExecutable;
import ch.tatool.element.Element;
import ch.tatool.element.Initializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageListInstructionExecutable
extends ListInstructionExecutable
implements Initializable {
    private Logger logger = LoggerFactory.getLogger(ImageListInstructionExecutable.class);
    private List<String> images;

    public ImageListInstructionExecutable() {
        super("image-instruction");
    }

    public void initialize(Element element) {
        this.loadImages();
    }

    private void loadImages() {
        ArrayList<JPanel> panels = new ArrayList<JPanel>();
        for (String path : this.images) {
            URL imageURL;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Searching resource " + path);
            }
            if ((imageURL = this.getClass().getResource(path)) == null) {
                this.logger.warn("Resource file not found: " + path);
                continue;
            }
            ImageIcon icon = new ImageIcon(imageURL);
            CenteredTextPanel panel = new CenteredTextPanel();
            panel.setIcon(icon);
            panels.add(panel);
        }
        this.setPanels(panels);
    }

    public List<String> getImages() {
        return this.images;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }
}

