/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.executable;

import ch.tatool.core.executable.BlockingExecutable;
import ch.tatool.element.Executable;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingAWTExecutable
extends BlockingExecutable
implements Executable {
    private Logger logger = LoggerFactory.getLogger(BlockingAWTExecutable.class);

    public BlockingAWTExecutable() {
    }

    public BlockingAWTExecutable(String defaultId) {
        super(defaultId);
    }

    @Override
    protected final void startExecution() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BlockingAWTExecutable.this.startExecutionAWT();
                }
            });
        }
        catch (InvocationTargetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract void startExecutionAWT();

    @Override
    protected final void cancelExecution() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cancelExecutionAWT();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BlockingAWTExecutable.this.cancelExecutionAWT();
                    }
                });
            }
            catch (InvocationTargetException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected void cancelExecutionAWT() {
    }
}

