/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.executable;

import ch.tatool.core.display.swing.ExecutionDisplayUtils;
import ch.tatool.core.display.swing.SwingExecutionDisplay;
import ch.tatool.core.display.swing.action.ActionPanel;
import ch.tatool.core.display.swing.action.ActionPanelListener;
import ch.tatool.core.display.swing.action.KeyActionPanel;
import ch.tatool.core.display.swing.container.ContainerUtils;
import ch.tatool.core.display.swing.container.RegionsContainer;
import ch.tatool.core.executable.BlockingAWTExecutable;
import javax.swing.JPanel;

public abstract class AbstractInstructionExecutable
extends BlockingAWTExecutable
implements ActionPanelListener {
    private KeyActionPanel actionPanel = new KeyActionPanel();
    private int currentIndex;

    public AbstractInstructionExecutable() {
        this("instruction");
    }

    public AbstractInstructionExecutable(String elementName) {
        super(elementName);
        this.actionPanel.addActionPanelListener(this);
    }

    private void setupActionPanelKeys(int index) {
        this.actionPanel.removeKeys();
        if (index > 0) {
            this.actionPanel.addKey(37, "Zur\u00fcck", -1);
            this.actionPanel.addKey(39, "Weiter", 1);
        } else {
            this.actionPanel.addKey(39, "Weiter", 1);
        }
        this.actionPanel.validate();
    }

    @Override
    protected void startExecutionAWT() {
        RegionsContainer regionsContainer = ContainerUtils.getRegionsContainer();
        SwingExecutionDisplay display = ExecutionDisplayUtils.getDisplay(this.getExecutionContext());
        ContainerUtils.showRegionsContainer(display);
        regionsContainer.setRegionVisibility(RegionsContainer.Region.NORTH, false);
        if (this.getInstructionCount() < 1) {
            this.getFinishExecutionLock();
            return;
        }
        this.setupInstruction(0);
    }

    private void setupInstruction(int index) {
        RegionsContainer regionsContainer = ContainerUtils.getRegionsContainer();
        JPanel instructionPanel = this.getInstruction(index);
        regionsContainer.removeRegionContent(RegionsContainer.Region.CENTER);
        regionsContainer.setRegionContent(RegionsContainer.Region.CENTER, instructionPanel);
        regionsContainer.removeRegionContent(RegionsContainer.Region.SOUTH);
        this.setupActionPanelKeys(index);
        regionsContainer.setRegionContent(RegionsContainer.Region.SOUTH, this.actionPanel);
        regionsContainer.setRegionContentVisibility(RegionsContainer.Region.SOUTH, true);
        regionsContainer.setRegionContentVisibility(RegionsContainer.Region.CENTER, true);
        this.actionPanel.enableActionPanel();
        this.currentIndex = index;
    }

    @Override
    protected void cancelExecutionAWT() {
        this.actionPanel.disableActionPanel();
        RegionsContainer regionsContainer = ContainerUtils.getRegionsContainer();
        regionsContainer.removeRegionContent(RegionsContainer.Region.CENTER);
        regionsContainer.removeRegionContent(RegionsContainer.Region.SOUTH);
    }

    @Override
    public void actionTriggered(ActionPanel source, Object actionValue) {
        int newIndex = 0;
        int addIndex = (Integer)actionValue;
        this.actionPanel.disableActionPanel();
        if (this.currentIndex + addIndex >= 0) {
            newIndex = this.currentIndex + addIndex;
        }
        if (newIndex < this.getInstructionCount()) {
            this.setupInstruction(newIndex);
            return;
        }
        if (this.getFinishExecutionLock()) {
            this.cancelExecutionAWT();
            this.finishExecution();
        }
    }

    protected abstract int getInstructionCount();

    protected abstract JPanel getInstruction(int var1);
}

