/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.score;

import ch.tatool.core.data.IntegerProperty;
import ch.tatool.core.data.Level;
import ch.tatool.core.data.Misc;
import ch.tatool.core.display.swing.container.RegionsContainer;
import ch.tatool.core.display.swing.panel.CenteredTextPanel;
import ch.tatool.core.element.ExecutableElement;
import ch.tatool.core.element.NodeImpl;
import ch.tatool.core.element.TemporaryElementSupportUtil;
import ch.tatool.core.element.handler.pause.PauseHandlerUtil;
import ch.tatool.core.element.handler.score.PointsAndLevelHandler;
import ch.tatool.core.executable.GenericContentExecutable;
import ch.tatool.data.PropertyHolder;
import ch.tatool.element.Element;
import ch.tatool.element.TemporaryElementSupport;
import ch.tatool.exec.ExecutionContext;

public class UserFeedbackLevelListener
extends NodeImpl
implements PointsAndLevelHandler.LevelListener {
    public static final String PROPERTY_DISPLAY_DURATION = "displayDuration";
    private static final int DEFAULT_DISPLAY_DURATION = 3000;
    private IntegerProperty durationProperty = new IntegerProperty("displayDuration");

    public UserFeedbackLevelListener() {
        this.setDisplayDuration(3000);
    }

    @Override
    public void levelChanged(PointsAndLevelHandler handler, ExecutionContext context) {
        int levelChange = Level.getLevelChangeDeltaProperty().getValue((PropertyHolder)handler, 0);
        this.insertLevelChangeInformationElement(context, levelChange);
    }

    protected void insertLevelChangeInformationElement(ExecutionContext context, int levelChange) {
        int duration = (Integer)this.durationProperty.getValue(this);
        if (duration <= 0) {
            return;
        }
        CenteredTextPanel textPanel = new CenteredTextPanel();
        if (levelChange > 0) {
            textPanel.setText("Congratulations, you achieved the next level!");
        } else {
            textPanel.setText("Let's try an easier level!");
        }
        GenericContentExecutable changeLevelExecutable = new GenericContentExecutable();
        changeLevelExecutable.addContent(RegionsContainer.Region.CENTER, textPanel);
        changeLevelExecutable.setDisplayDuration(duration);
        Misc.getOutcomeProperty().setValue(changeLevelExecutable, "SKIP");
        TemporaryElementSupport support = TemporaryElementSupportUtil.getInstance().findTemporaryElementSupport(context);
        if (support != null) {
            ExecutableElement element = new ExecutableElement(changeLevelExecutable);
            support.addTemporaryElement((Element)element);
        }
        PauseHandlerUtil.setCurrentInterElementPauseDuration(context, 0L);
    }

    public void setDisplayDuration(int displayDuration) {
        this.durationProperty.setValue(this, displayDuration);
    }

    public int getDisplayDuration() {
        return (Integer)this.durationProperty.getValue(this);
    }
}

