/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.score;

import ch.tatool.core.data.Misc;
import ch.tatool.core.element.handler.score.PointsAndLevelHandler;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Module;
import ch.tatool.data.PropertyHolder;
import java.util.HashSet;
import java.util.Set;

public class PointsAndLevelUtils {
    public static final String PROPERTY_REGISTERED_POINTS_AND_LEVEL_HANDLERS = "registeredPointsAndLevelHandlers";
    private static final String REGISTERED_MARKER = "PointsAndLevelHandlerRegistered";

    public static Set<String> getRegisteredPointsAndLevelHandlers(Module module) {
        return PointsAndLevelUtils.fetchStringSetProperty((DataContainer)module, "", PROPERTY_REGISTERED_POINTS_AND_LEVEL_HANDLERS, ",");
    }

    public static String getPointsAndLevelHandlerDescription(Module module, String handlerId) {
        return (String)Misc.getDescriptionProperty().getValue((DataContainer)module, handlerId);
    }

    public static void registerPointAndLevelHandler(Module module, PointsAndLevelHandler handler) {
        if (handler.getProperty(REGISTERED_MARKER) != null) {
            return;
        }
        String id = handler.getId();
        Set<String> handlerIds = PointsAndLevelUtils.getRegisteredPointsAndLevelHandlers(module);
        handlerIds.add(id);
        PointsAndLevelUtils.setStringSetProperty((DataContainer)module, "", PROPERTY_REGISTERED_POINTS_AND_LEVEL_HANDLERS, handlerIds, ",");
        Misc.getDescriptionProperty().setValue((DataContainer)module, (PropertyHolder)handler);
        handler.setProperty(REGISTERED_MARKER, "registered");
    }

    private static Set<String> fetchStringSetProperty(DataContainer dataContainer, String node, String propertyName, String delimiter) {
        String propertyValue = dataContainer.getValue(node, propertyName);
        if (propertyValue != null) {
            String[] values = propertyValue.split(delimiter);
            HashSet<String> valueSet = new HashSet<String>();
            for (String value : values) {
                valueSet.add(value);
            }
            return valueSet;
        }
        return new HashSet<String>();
    }

    private static void setStringSetProperty(DataContainer dataContainer, String node, String propertyName, Set<String> values, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (String s : values) {
            builder.append(s).append(delimiter);
        }
        int len = builder.length();
        if (len > 0) {
            builder.deleteCharAt(len - 1);
        }
        String value = builder.toString();
        dataContainer.putValue(node, propertyName, value);
    }
}

