/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.score;

import ch.tatool.core.element.handler.score.AbstractPointAdaptor;
import ch.tatool.core.element.handler.score.PointsAndLevelHandler;
import ch.tatool.data.Trial;
import ch.tatool.exec.ExecutionContext;

public class FactorPointAdaptor
extends AbstractPointAdaptor {
    public static final String PROPERTY_FACTOR = "factor";

    public FactorPointAdaptor() {
        this(1);
    }

    public FactorPointAdaptor(int factor) {
        this.setFactor(factor);
    }

    public void setFactor(int factor) {
        this.setProperty(PROPERTY_FACTOR, factor);
    }

    public int getFactor() {
        return (Integer)this.getProperty(PROPERTY_FACTOR);
    }

    @Override
    public void adaptPoints(PointsAndLevelHandler handler, ExecutionContext context) {
        int factor = this.getFactor();
        for (Trial trial : context.getExecutionData().getTrials()) {
            Integer maxPoints;
            Integer points;
            Integer minPoints = this.getMinPointsToAdapt(trial, handler);
            if (minPoints != null) {
                this.setAdaptedMinPoints(trial, handler, minPoints * factor);
            }
            if ((points = this.getPointsToAdapt(trial, handler)) != null) {
                this.setAdaptedPoints(trial, handler, points * factor);
            }
            if ((maxPoints = this.getMaxPointsToAdapt(trial, handler)) == null) continue;
            this.setAdaptedMaxPoints(trial, handler, maxPoints * factor);
        }
    }
}

