/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element.handler.score;

import ch.tatool.core.data.DoubleProperty;
import ch.tatool.core.data.IntegerProperty;
import ch.tatool.core.data.Misc;
import ch.tatool.core.data.Points;
import ch.tatool.core.element.CompoundElement;
import ch.tatool.core.element.CompoundSelector;
import ch.tatool.core.element.handler.score.AbstractPointsAndLevelHandler;
import ch.tatool.core.element.handler.timeout.DefaultAdaptiveTimeoutHandler;
import ch.tatool.data.DataContainer;
import ch.tatool.data.Module;
import ch.tatool.data.PropertyHolder;
import ch.tatool.data.Trial;
import ch.tatool.element.Element;
import ch.tatool.element.Executable;
import ch.tatool.exec.ExecutionContext;
import java.util.ArrayList;
import java.util.List;

public class AdaptiveScoreAndLevelHandler
extends AbstractPointsAndLevelHandler {
    private int benchmarkSampleSize = 20;
    private double minBenchmark = 0.5;
    private double maxBenchmark = 1.0;
    private double benchmarkRaise = 0.0;
    private int numRetriesTimer = -1;
    private int numRetriesBenchmark = -1;
    private boolean doBenchmark = true;
    private double benchmark = 0.0;
    private double benchmarkTotalPoints = 0.0;
    private double benchmarkMaxPoints = 0.0;
    private int counter = 0;
    private int retryTimer = 0;
    private int retryBenchmark = 0;
    public static final String PROPERTY_BENCHMARK = "benchmark";
    public static final String PROPERTY_BENCHMARK_COUNTER = "benchmarkCounter";
    public static final String PROPERTY_PERFORMANCE = "performance";
    public static final String PROPERTY_TOTALPOINTS = "benchmarkTotalPoints";
    public static final String PROPERTY_MAXPOINTS = "benchmarkMaxPoints";
    private static DoubleProperty benchmarkProperty = new DoubleProperty("benchmark");
    private static IntegerProperty counterProperty = new IntegerProperty("benchmarkCounter");
    private static DoubleProperty performanceProperty = new DoubleProperty("performance");
    private static DoubleProperty benchmarkTotalPointsProperty = new DoubleProperty("benchmarkTotalPoints");
    private static DoubleProperty benchmarkMaxPointsProperty = new DoubleProperty("benchmarkMaxPoints");
    public static final int RESET = 2;
    public static final int INCREASE = 1;
    public static final int REDUCE = -1;
    public static final int ADAPT = 0;
    private double totalScore = 0.0;
    private double maxScore = 0.0;
    private List<DefaultAdaptiveTimeoutHandler> timeoutHandlers = new ArrayList<DefaultAdaptiveTimeoutHandler>();

    public AdaptiveScoreAndLevelHandler() {
        super("adaptive-score-and-level-handler");
    }

    @Override
    protected void initializeHandler(ExecutionContext context) {
        Module module = context.getExecutionData().getModule();
        this.benchmarkTotalPoints = benchmarkTotalPointsProperty.getValue((DataContainer)module, this, Double.valueOf(0.0));
        this.benchmarkMaxPoints = benchmarkMaxPointsProperty.getValue((DataContainer)module, this, Double.valueOf(0.0));
        this.totalScore = this.benchmarkTotalPoints;
        this.maxScore = this.benchmarkMaxPoints;
    }

    public void initializeAlgorithm(ExecutionContext event) {
        Module module = event.getExecutionData().getModule();
        this.counter = counterProperty.getValue((DataContainer)module, this, Integer.valueOf(0));
        this.benchmark = benchmarkProperty.getValue((DataContainer)module, this, Double.valueOf(0.0));
        this.doBenchmark = !(this.benchmark > 0.0);
    }

    @Override
    protected int checkLevelChange(ExecutionContext context, int currentLevel) {
        int oldLevel;
        List trials = context.getExecutionData().getTrials();
        int newLevel = oldLevel = currentLevel;
        Executable executable = context.getActiveExecutable();
        for (int i = 0; i < trials.size(); ++i) {
            Trial trial = (Trial)trials.get(i);
            this.totalScore += (double)Points.getPointsProperty().getValue((DataContainer)trial, trial.getParentId(), Integer.valueOf(0)).intValue();
            this.maxScore += (double)Points.getMaxPointsProperty().getValue((DataContainer)trial, trial.getParentId(), Integer.valueOf(0)).intValue();
            if (trials.isEmpty()) {
                return currentLevel;
            }
            String trialOutcome = (String)Misc.getOutcomeProperty().getValue((DataContainer)trial, (PropertyHolder)executable);
            if (trialOutcome.equals("FINISHED") && this.isCompoundDone(context, trial)) {
                this.initializeAlgorithm(context);
                ++this.counter;
                benchmarkProperty.setValue((DataContainer)trial, this, Double.valueOf(this.benchmark));
                counterProperty.setValue((DataContainer)trial, this, Integer.valueOf(this.counter));
                if (this.counter == this.benchmarkSampleSize) {
                    boolean reset;
                    double performance;
                    if (this.doBenchmark) {
                        performance = this.totalScore / this.maxScore + this.benchmarkRaise;
                        if (performance >= this.minBenchmark) {
                            this.setBenchmark(context);
                        } else {
                            reset = this.retryBenchmark(context);
                            if (reset && oldLevel > 1) {
                                newLevel = this.changeLevel(context, oldLevel, -1);
                            }
                        }
                    } else {
                        performance = this.totalScore / this.maxScore;
                        if (performance >= this.benchmark) {
                            newLevel = this.changeLevel(context, oldLevel, 1);
                        } else {
                            reset = this.retryBenchmark(context);
                            if (reset && oldLevel > 1) {
                                newLevel = this.changeLevel(context, oldLevel, -1);
                            }
                        }
                        performanceProperty.setValue((DataContainer)trial, this, Double.valueOf(performance));
                    }
                }
                counterProperty.setValue((DataContainer)context.getExecutionData().getModule(), this, Integer.valueOf(this.counter));
            }
            benchmarkTotalPointsProperty.setValue((DataContainer)context.getExecutionData().getModule(), this, Double.valueOf(this.totalScore));
            benchmarkMaxPointsProperty.setValue((DataContainer)context.getExecutionData().getModule(), this, Double.valueOf(this.maxScore));
        }
        return newLevel;
    }

    private void setBenchmark(ExecutionContext context) {
        this.benchmark = this.totalScore / this.maxScore + this.benchmarkRaise;
        if (this.benchmark > this.maxBenchmark) {
            this.benchmark = this.maxBenchmark;
        }
        benchmarkProperty.setValue((DataContainer)context.getExecutionData().getModule(), this, Double.valueOf(this.benchmark));
        this.doBenchmark = false;
        this.adaptTimer(context, 0);
        this.counter = 0;
        this.retryTimer = 0;
        this.retryBenchmark = 0;
        this.totalScore = 0.0;
        this.maxScore = 0.0;
    }

    private boolean retryBenchmark(ExecutionContext context) {
        boolean retryReset = false;
        ++this.retryTimer;
        ++this.retryBenchmark;
        if (this.retryTimer >= this.numRetriesTimer && this.numRetriesTimer > 0) {
            this.adaptTimer(context, 1);
            this.retryTimer = 0;
        }
        if (this.retryBenchmark >= this.numRetriesBenchmark && this.numRetriesBenchmark > 0) {
            this.benchmark = 0.0;
            this.doBenchmark = true;
            this.retryBenchmark = 0;
            benchmarkProperty.setValue((DataContainer)context.getExecutionData().getModule(), this, Double.valueOf(0.0));
            retryReset = true;
        }
        this.counter = 0;
        this.totalScore = 0.0;
        this.maxScore = 0.0;
        return retryReset;
    }

    private int changeLevel(ExecutionContext event, int oldLevel, int addition) {
        int newLevel = oldLevel + addition;
        benchmarkProperty.setValue((DataContainer)event.getExecutionData().getModule(), this, Double.valueOf(0.0));
        this.benchmark = 0.0;
        this.counter = 0;
        this.retryTimer = 0;
        this.retryBenchmark = 0;
        this.doBenchmark = true;
        this.totalScore = 0.0;
        this.maxScore = 0.0;
        this.adaptTimer(event, 2);
        return newLevel;
    }

    private boolean isCompoundDone(ExecutionContext context, Trial trial) {
        boolean isDone = true;
        for (Element currElement = context.getActiveElement(); this.getParent() != null && this.getParent() != currElement; currElement = currElement.getParent()) {
            if (currElement instanceof CompoundElement) {
                CompoundElement comp = (CompoundElement)currElement;
                for (Object handler : comp.getHandlers()) {
                    if (!(handler instanceof CompoundSelector)) continue;
                    CompoundSelector selector = (CompoundSelector)handler;
                    isDone = selector.isDone();
                }
            }
            if (currElement.getParent() != null) {
                continue;
            }
            return true;
        }
        return isDone;
    }

    private void adaptTimer(ExecutionContext event, int mode) {
        block6: for (int i = 0; i < this.timeoutHandlers.size(); ++i) {
            DefaultAdaptiveTimeoutHandler timeoutHandler = this.timeoutHandlers.get(i);
            switch (mode) {
                case 1: {
                    timeoutHandler.increaseTimeoutDuration(event);
                    continue block6;
                }
                case -1: {
                    timeoutHandler.decreaseTimeoutDuration(event);
                    continue block6;
                }
                case 0: {
                    timeoutHandler.adaptTimeoutDuration(event);
                    continue block6;
                }
                case 2: {
                    if (!timeoutHandler.isResetTimerDuration()) continue block6;
                    timeoutHandler.resetTimeoutDuration(event);
                    continue block6;
                }
            }
        }
    }

    public int getBenchmarkSampleSize() {
        return this.benchmarkSampleSize;
    }

    public void setBenchmarkSampleSize(int benchmarkSampleSize) {
        this.benchmarkSampleSize = benchmarkSampleSize;
    }

    public double getBenchmarkRaise() {
        return this.benchmarkRaise;
    }

    public void setBenchmarkRaise(double benchmarkRaise) {
        this.benchmarkRaise = benchmarkRaise;
    }

    public double getMinBenchmark() {
        return this.minBenchmark;
    }

    public void setMinBenchmark(double minBenchmark) {
        this.minBenchmark = minBenchmark;
    }

    public double getMaxBenchmark() {
        return this.maxBenchmark;
    }

    public void setMaxBenchmark(double maxBenchmark) {
        this.maxBenchmark = maxBenchmark;
    }

    public int getNumRetriesTimer() {
        return this.numRetriesTimer;
    }

    public void setNumRetriesTimer(int numRetriesTimer) {
        this.numRetriesTimer = numRetriesTimer;
    }

    public int getNumRetriesBenchmark() {
        return this.numRetriesBenchmark;
    }

    public void setNumRetriesBenchmark(int numRetriesBenchmark) {
        this.numRetriesBenchmark = numRetriesBenchmark;
    }
}

