/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.core.element.AbstractListSelector;
import ch.tatool.core.element.ElementUtils;
import ch.tatool.core.element.ExecutionStartHandler;
import ch.tatool.element.Element;
import ch.tatool.exec.ExecutionContext;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class TimerListSelector
extends AbstractListSelector
implements ExecutionStartHandler {
    private long timeout = 10000L;
    private Iterator<Element> iterator;
    private TimerTask stopTask;
    private boolean timerRunning;
    private boolean canCreateIterator;
    private Timer execTimer;

    public TimerListSelector() {
    }

    public TimerListSelector(int timeoutSeconds) {
        this.timeout = timeoutSeconds;
    }

    @Override
    public void initialize(Element element) {
        super.initialize(element);
        this.iterator = null;
        this.execTimer = new Timer();
        this.canCreateIterator = true;
        this.timerRunning = false;
    }

    public boolean selectNextElement(ExecutionContext context) {
        if (this.canCreateIterator) {
            this.iterator = this.createIterator(context);
        } else if (this.iterator != null && !this.iterator.hasNext()) {
            this.iterator = this.canCreateIterator() ? this.createIterator(context) : null;
        }
        if (this.iterator == null || !this.canExecuteNext()) {
            return false;
        }
        Element next = this.iterator.next();
        ElementUtils.initialize(next);
        context.getExecutor().getExecutionTree().pushElement(next);
        return true;
    }

    protected boolean canCreateIterator() {
        return this.timerRunning;
    }

    protected boolean canExecuteNext() {
        return true;
    }

    protected Iterator<Element> createIterator(ExecutionContext context) {
        return this.getExecutionElement().getChildren().iterator();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void startExecution(final ExecutionContext context) {
        if (!this.timerRunning) {
            this.timerRunning = true;
            this.stopTask = new TimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TimerListSelector.this.stopExecution(context);
                        }
                    });
                }
            };
            this.execTimer.schedule(this.stopTask, this.timeout);
        }
    }

    @Override
    public void stopExecution(ExecutionContext context) {
        context.getExecutor().stopCurrentElementExecution();
        context.getExecutor().getExecutionTree().popElement();
        this.stopTimer();
    }

    @Override
    public void stopTimer() {
        this.stopTask.cancel();
        this.canCreateIterator = false;
        this.iterator = null;
    }
}

