/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.core.element.IteratedListSelector;
import ch.tatool.element.Element;
import ch.tatool.element.Initializable;

public class TemporalListSelector
extends IteratedListSelector
implements Initializable {
    private static long convertRateToMilliseconds = 1000000L;
    private long startTime = 0L;
    private long timeout = 10000L;

    private long getNanoTime() {
        long nanoTime = System.nanoTime();
        return nanoTime;
    }

    @Override
    public void initialize(Element element) {
        super.initialize(element);
        this.startTime = this.getNanoTime();
    }

    @Override
    protected boolean canCreateIterator() {
        return true;
    }

    @Override
    protected boolean canExecuteNext() {
        return (this.getNanoTime() - this.startTime) / convertRateToMilliseconds < this.timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

