/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.core.element.AbstractPropertyHolder;
import ch.tatool.element.Element;
import ch.tatool.element.Node;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class NodeImpl
extends AbstractPropertyHolder
implements Node {
    private String localId;
    private Node parent;

    public NodeImpl() {
        this("node");
    }

    public NodeImpl(String defaultId) {
        this.setLocalId(defaultId + "-" + (1000 + new Random().nextInt(8999)));
    }

    public void setId(String id) {
        this.localId = id;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String id) {
        this.localId = id;
    }

    public String getId() {
        LinkedList<NodeImpl> nodes = new LinkedList<NodeImpl>();
        for (NodeImpl u = this; u != null; u = u.getParent()) {
            nodes.addFirst(u);
        }
        StringBuilder builder = new StringBuilder();
        Iterator it = nodes.iterator();
        NodeImpl n = (NodeImpl)it.next();
        builder.append(n.getLocalId());
        while (it.hasNext()) {
            n = (NodeImpl)it.next();
            builder.append('.');
            builder.append(n.getLocalId());
        }
        return builder.toString();
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    protected static void assignParent(Node parent, Object object) {
        if (object instanceof Node) {
            ((Node)object).setParent(parent);
        }
    }

    protected static void assignParent(Node parent, Collection<Object> objects) {
        for (Object object : objects) {
            NodeImpl.assignParent(parent, object);
        }
    }

    protected static void assignParents(Node parent, Collection<Element> objects) {
        for (Element object : objects) {
            NodeImpl.assignParent(parent, object);
        }
    }
}

