/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.element;

import ch.tatool.core.data.Misc;
import ch.tatool.core.element.ElementUtils;
import ch.tatool.data.PropertyHolder;
import ch.tatool.element.Element;
import ch.tatool.element.ElementSelector;
import ch.tatool.element.ElementTree;
import ch.tatool.element.ExecutionStrategy;
import ch.tatool.element.TemporaryElementSupport;
import ch.tatool.exec.ExecutionContext;
import java.util.LinkedList;
import java.util.Queue;

public class DefaultExecutionStrategy
implements ExecutionStrategy,
TemporaryElementSupport {
    private Queue<Element> temporaryElements = new LinkedList<Element>();

    public void addTemporaryElement(Element element) {
        this.temporaryElements.add(element);
    }

    public boolean updateElementStack(ExecutionContext executionContext) {
        ElementTree tree = executionContext.getExecutor().getExecutionTree();
        if (tree.getElementStack().isEmpty()) {
            tree.pushElement(tree.getRootElement());
            ElementUtils.initialize(tree.getRootElement());
        }
        int x = 0;
        while (x < 100) {
            if (this.isTopExecutable(tree)) {
                return true;
            }
            if (this.runTopSelectors(executionContext, tree) || this.hasTemporaryElement(tree)) continue;
            tree.popElement();
            if (!tree.getElementStack().isEmpty()) continue;
            return false;
        }
        Misc.getOutcomeProperty().clearValue((PropertyHolder)executionContext);
        Element top = tree.getTop();
        return top != null && top.getExecutable() != null;
    }

    private boolean isTopExecutable(ElementTree tree) {
        Object executed;
        Element top = tree.getTop();
        return top != null && top.getExecutable() != null && ((executed = top.getProperty("executed")) == null || executed.equals(Boolean.FALSE));
    }

    private boolean hasTemporaryElement(ElementTree tree) {
        Element first = this.temporaryElements.poll();
        if (first != null) {
            tree.pushElement(first);
            return true;
        }
        return false;
    }

    private boolean runTopSelectors(ExecutionContext executionContext, ElementTree tree) {
        Element top = tree.getTop();
        for (Object handler : top.getHandlers()) {
            boolean adapted;
            if (!(handler instanceof ElementSelector) || !(adapted = ((ElementSelector)handler).selectNextElement(executionContext))) continue;
            return true;
        }
        return false;
    }
}

