/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.status;

import ch.tatool.core.display.swing.status.StatusPanel;
import ch.tatool.core.display.swing.status.StatusRegion;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class StatusRegionImpl
extends JPanel
implements StatusRegion {
    private static final long serialVersionUID = 1L;
    private List<StatusPanel> panels = new ArrayList<StatusPanel>();
    private List<String> ids = new ArrayList<String>();
    private Map<String, StatusPanel> idsToPanels = new HashMap<String, StatusPanel>();
    private GridLayout gridLayout = new GridLayout();

    public StatusRegionImpl() {
        this.gridLayout.setHgap(15);
        this.setOpaque(false);
        this.setLayout(this.gridLayout);
    }

    @Override
    public List<StatusPanel> getStatusPanels() {
        return Collections.unmodifiableList(this.panels);
    }

    @Override
    public void addStatusPanel(String id, StatusPanel statusPanel) {
        this.addStatusPanel(id, statusPanel, this.panels.size());
    }

    @Override
    public void addStatusPanel(String id, StatusPanel statusPanel, int index) {
        this.removeStatusPanel(id);
        int position = index;
        if (position < 0) {
            position = 0;
        }
        if (position > this.panels.size()) {
            position = this.panels.size();
        }
        this.idsToPanels.put(id, statusPanel);
        this.panels.add(position, statusPanel);
        this.ids.add(position, id);
        this.add((Component)statusPanel.getView(), position);
        this.revalidate();
        this.repaint();
    }

    @Override
    public StatusPanel getStatusPanel(String id) {
        return this.idsToPanels.get(id);
    }

    @Override
    public List<String> getStatusPanelIds() {
        return new ArrayList<String>(this.ids);
    }

    @Override
    public void reoderStatusPanels(List<String> statusPanelIds) {
        ArrayList<String> newIds = new ArrayList<String>(statusPanelIds);
        newIds.retainAll(this.ids);
        this.ids.removeAll(statusPanelIds);
        newIds.addAll(this.ids);
        this.ids = newIds;
        this.removeAll();
        this.panels.clear();
        for (String id : this.ids) {
            StatusPanel statusPanel = this.idsToPanels.get(id);
            this.panels.add(statusPanel);
            this.add(statusPanel.getView());
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeStatusPanel(String id) {
        if (this.idsToPanels.containsKey(id)) {
            StatusPanel panel = this.idsToPanels.remove(id);
            this.panels.remove(panel);
            this.ids.remove(this.ids.indexOf(id));
            this.remove(panel.getView());
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeAllPanels() {
        this.panels.clear();
        this.ids.clear();
        this.idsToPanels.clear();
        this.removeAll();
        this.revalidate();
        this.repaint();
    }
}

