/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.matrix;

import ch.tatool.core.display.swing.matrix.RotatedLabelTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FixedSizeTable
extends JPanel {
    private static final long serialVersionUID = 8592868130625954697L;
    private int rowHeight = 30;
    private int columnWidth = 30;
    private JTable table;

    public FixedSizeTable() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setRowHeight(this.rowHeight);
        this.updateColumnWidths();
        GridBagConstraints gbc = new GridBagConstraints();
        this.add((Component)this.table, gbc);
        this.setBorder(new LineBorder(Color.BLACK, 1));
    }

    private void updateColumnWidths() {
        int columnCount = this.table.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.columnWidth);
        }
    }

    public void setTableModel(TableModel dataModel) {
        this.table.setModel(dataModel);
        this.table.setRowHeight(this.rowHeight);
        this.updateColumnWidths();
    }

    public void setTableCellRenderer(TableCellRenderer cellRenderer) {
        this.table.setDefaultRenderer(Object.class, cellRenderer);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
        this.table.setRowHeight(rowHeight);
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
        this.updateColumnWidths();
    }

    public JTable getTable() {
        return this.table;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Matrix test");
        FixedSizeTable matrix = new FixedSizeTable();
        DefaultTableModel model = new DefaultTableModel(10, 10);
        model.setValueAt("A", 0, 0);
        model.setValueAt("A[N]", 0, 1);
        model.setValueAt("A[R]", 0, 2);
        model.setValueAt("B[H]", 1, 0);
        model.setValueAt("B[H][V]", 1, 1);
        model.setValueAt("B[H][V][R]", 1, 2);
        model.setValueAt("C[V]", 2, 0);
        model.setValueAt("C[V][R]", 2, 1);
        model.setValueAt("C[R]", 2, 2);
        matrix.setTableModel(model);
        RotatedLabelTableCellRenderer rotatedLabelTableCellRenderer = new RotatedLabelTableCellRenderer();
        rotatedLabelTableCellRenderer.setLabelFont(rotatedLabelTableCellRenderer.getLabelFont().deriveFont((float)rotatedLabelTableCellRenderer.getLabelFont().getSize() + 6.0f));
        matrix.setTableCellRenderer(rotatedLabelTableCellRenderer);
        matrix.setRowHeight(40);
        matrix.setColumnWidth(40);
        JPanel root = new JPanel(new BorderLayout());
        frame.getContentPane().add(root);
        root.add(matrix);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

