/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing.action;

import ch.tatool.core.display.swing.action.AbstractActionPanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class ListActionPanel
extends AbstractActionPanel {
    private static final long serialVersionUID = -6768844783262584074L;
    private boolean enabled;
    private Object actionValue;
    private DefaultListModel listModel = new DefaultListModel();
    private SubmitKeyEventDispatcher keyEventDispatcher;
    JList answerList;
    JButton submitButton;

    public ListActionPanel() {
        this.initComponents();
        this.keyEventDispatcher = new SubmitKeyEventDispatcher();
        this.actionValue = null;
    }

    public void setButtonText(String label) {
        this.submitButton.setText(label);
    }

    public void addListEntry(Object o) {
        this.listModel.addElement(o);
    }

    public Object getListEntry(int index) {
        return this.listModel.getElementAt(index);
    }

    public void clearList() {
        this.listModel.removeAllElements();
    }

    public Object getActionValue() {
        return this.actionValue;
    }

    public void setActionValue(Object actionValue) {
        this.actionValue = actionValue;
    }

    @Override
    public void enableActionPanel() {
        this.enabled = true;
        this.answerList.setSelectedIndex(0);
        this.answerList.ensureIndexIsVisible(0);
        this.answerList.requestFocusInWindow();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
    }

    @Override
    public void disableActionPanel() {
        this.enabled = false;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }

    private void initComponents() {
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.answerList = new JList();
        this.submitButton = new JButton();
        this.setPreferredSize(new Dimension(323, 360));
        jPanel2.setOpaque(false);
        this.answerList.setFont(this.answerList.getFont().deriveFont((float)this.answerList.getFont().getSize() + 8.0f));
        this.answerList.setModel(this.listModel);
        this.answerList.setSelectionMode(0);
        this.answerList.setVisibleRowCount(10);
        this.answerList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ListActionPanel.this.answerListMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(this.answerList);
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 303, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, -1, 201, Short.MAX_VALUE));
        this.submitButton.setFont(this.submitButton.getFont().deriveFont((float)this.submitButton.getFont().getSize() + 10.0f));
        this.submitButton.setText("FINISHED");
        this.submitButton.setMargin(new Insets(8, 20, 8, 20));
        this.submitButton.setMaximumSize(new Dimension(0, 0));
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListActionPanel.this.submitButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.submitButton, GroupLayout.Alignment.LEADING, -1, 303, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.submitButton, -2, 43, -2).addContainerGap()));
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        if (this.enabled) {
            if (this.answerList.getSelectedValue() == null) {
                this.setActionValue("");
            } else {
                this.setActionValue(this.answerList.getSelectedValue());
            }
            this.fireActionTriggered(this.actionValue);
        }
    }

    private void answerListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.fireActionTriggered(this.actionValue);
        }
    }

    class SubmitKeyEventDispatcher
    implements KeyEventDispatcher {
        SubmitKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                switch (e.getKeyCode()) {
                    case 10: 
                    case 32: {
                        ListActionPanel.this.submitButton.doClick();
                    }
                }
            }
            return false;
        }
    }
}

