/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.display.swing;

import ch.tatool.core.display.swing.SwingExecutionDisplay;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingExecutionFrame
extends JFrame
implements SwingExecutionDisplay {
    private static final long serialVersionUID = 5488252067183749247L;
    Logger logger = LoggerFactory.getLogger(SwingExecutionFrame.class);
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private boolean fullScreenModeEnabled = true;
    private boolean screenModeInitialized = false;
    Map<String, Component> contents = new HashMap<String, Component>();
    private Component overlayComponent;
    private CardLayout cardLayout;
    private JPanel emptyCard;
    private JPanel rootPanel;

    public SwingExecutionFrame() {
        this.initComponents();
        this.rootPanel.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.cardLayout = (CardLayout)this.rootPanel.getLayout();
        this.getLayeredPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingExecutionFrame.this.resizeOverlayComponent();
            }
        });
    }

    public void setFullScreenModeEnabled(boolean fullScreenModeEnabled) {
        this.fullScreenModeEnabled = fullScreenModeEnabled;
    }

    public boolean isFullScreenModeEnabled() {
        return this.fullScreenModeEnabled;
    }

    private void initFullScreenMode() {
        this.setResizable(false);
        if (!this.isDisplayable()) {
            this.setUndecorated(true);
        }
    }

    private void showFrameInFullScreen() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.setVisible(true);
        gd.setFullScreenWindow(this);
    }

    private void removeFrameFromScreen() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        gd.setFullScreenWindow(null);
        this.setVisible(false);
    }

    public void showWindow() {
        if (!this.screenModeInitialized) {
            this.screenModeInitialized = true;
            if (this.fullScreenModeEnabled) {
                this.initFullScreenMode();
            }
        }
        if (this.fullScreenModeEnabled) {
            this.showFrameInFullScreen();
        } else {
            this.setSize(800, 600);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }

    public void hideWindow() {
        if (this.fullScreenModeEnabled) {
            this.removeFrameFromScreen();
        } else {
            this.setVisible(false);
        }
    }

    public void disposeWindow() {
        this.hideWindow();
        this.dispose();
    }

    @Override
    public void addCard(String cardId, Component component) {
        this.removeCard(cardId);
        this.contents.put(cardId, component);
        this.rootPanel.add(component, cardId);
    }

    @Override
    public void showCard(String cardId) {
        this.cardLayout.show(this.rootPanel, cardId);
    }

    @Override
    public void removeCard(String cardId) {
        Component component = this.contents.get(cardId);
        if (component != null) {
            this.rootPanel.remove(component);
            this.contents.remove(cardId);
        }
    }

    @Override
    public void removeAllCards() {
        for (Component component : this.contents.values()) {
            this.rootPanel.remove(component);
        }
        this.contents.clear();
    }

    @Override
    public void displayEmptyCard() {
        this.cardLayout.show(this.rootPanel, "emptyCard");
    }

    @Override
    public String getDisplayedCardId() {
        return null;
    }

    @Override
    public void setOverlay(Component component) {
        JLayeredPane layeredPane = this.getLayeredPane();
        if (this.overlayComponent != null) {
            layeredPane.remove(this.overlayComponent);
        }
        this.overlayComponent = component;
        if (this.overlayComponent != null) {
            layeredPane.add(this.overlayComponent, JLayeredPane.PALETTE_LAYER);
            this.resizeOverlayComponent();
        }
    }

    private void resizeOverlayComponent() {
        if (this.overlayComponent != null) {
            this.overlayComponent.setSize(this.getLayeredPane().getSize());
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.getRootPane().getBackground();
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.getRootPane().setBackground(color);
        } else {
            this.getRootPane().setBackground(DEFAULT_BACKGROUND_COLOR);
        }
    }

    private void initComponents() {
        this.rootPanel = new JPanel();
        this.emptyCard = new JPanel();
        this.rootPanel.setBackground(new Color(255, 255, 255));
        this.rootPanel.setLayout(new CardLayout());
        this.emptyCard.setBackground(new Color(255, 255, 255));
        this.emptyCard.setOpaque(false);
        this.rootPanel.add((Component)this.emptyCard, "emptyCard");
        this.getContentPane().add((Component)this.rootPanel, "Center");
    }
}

