/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.core.data;

import java.util.HashMap;
import java.util.Map;

public class StringConverter {
    private static Map<Class<?>, Converter<?>> converters = new HashMap();

    private StringConverter() {
    }

    public static void registerConverter(Class<?> c, Converter<?> converter) {
        converters.put(c, converter);
    }

    public static boolean containsConverter(Class<?> type) {
        return converters.containsKey(type);
    }

    public static Object convert(String s, Class<?> type) {
        Converter<?> converter = converters.get(type);
        if (converter == null) {
            throw new RuntimeException("No matching converter available");
        }
        return converter.convert(s);
    }

    static {
        converters.put(String.class, new IdentityConverter());
        converters.put(Integer.class, new IntegerConverter());
        converters.put(Long.class, new LongConverter());
        converters.put(Float.class, new FloatConverter());
        converters.put(Double.class, new DoubleConverter());
    }

    static class FloatConverter
    implements Converter<Float> {
        FloatConverter() {
        }

        @Override
        public Float convert(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }
    }

    static class DoubleConverter
    implements Converter<Double> {
        DoubleConverter() {
        }

        @Override
        public Double convert(String s) {
            return Double.parseDouble(s);
        }
    }

    static class LongConverter
    implements Converter<Long> {
        LongConverter() {
        }

        @Override
        public Long convert(String s) {
            return Long.parseLong(s);
        }
    }

    static class IntegerConverter
    implements Converter<Integer> {
        IntegerConverter() {
        }

        @Override
        public Integer convert(String s) {
            return Integer.parseInt(s);
        }
    }

    static class IdentityConverter
    implements Converter<String> {
        IdentityConverter() {
        }

        @Override
        public String convert(String s) {
            return s;
        }
    }

    public static interface Converter<T> {
        public T convert(String var1);
    }
}

