/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * TatoolOnlineDialog.java
 *
 * Created on 28.01.2011, 20:25:16
 */

package ch.tatool.core.module.creator;

import javax.swing.JOptionPane;

import ch.tatool.data.Messages;


/**
 * 
 * @author jrox
 */
public class TatoolOnlineDialog extends javax.swing.JDialog {

	private DataServerModuleCreator creator;
	private int studyID;
	private int moduleNR;
	private String code;
	private Messages messages;

	/** Creates new form TatoolOnlineDialog */
	public TatoolOnlineDialog(java.awt.Frame parent, boolean modal, Messages messages) {
		super(parent, modal);
		this.messages = messages;
		initComponents();
		getRootPane().setDefaultButton(okButton);
		setLocationRelativeTo(parent);
	}

	public void setCreator(DataServerModuleCreator dataServerModuleCreator) {
		creator = dataServerModuleCreator;
	}

	private void validateInput() {
		
		studyID = 0;
		moduleNR = 0;
		code = "";
		
		try {
			studyID = Integer.parseInt(studyTextField.getText());
			moduleNR = Integer.parseInt(moduleTextField.getText());
		} catch (NumberFormatException nFE) {
			JOptionPane.showMessageDialog(this,
					messages.getString("TatoolOnlineDialog.errorMessage.numeric"), messages.getString("General.errorMessage.windowTitle.error"),
					JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		if (studyID == 0 || moduleNR == 0) {
			JOptionPane.showMessageDialog(this,
					messages.getString("TatoolOnlineDialog.errorMessage.numeric"), messages.getString("General.errorMessage.windowTitle.error"),
					JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		if (codeTextField.getText().equals("")) {
			JOptionPane.showMessageDialog(this,
					messages.getString("TatoolOnlineDialog.errorMessage.missingCode"), messages.getString("General.errorMessage.windowTitle.error"),
					JOptionPane.ERROR_MESSAGE);
		} else {
			code = codeTextField.getText();
			String[] data = {String.valueOf(studyID), String.valueOf(moduleNR), code};
			creator.startLoading(data);
		}
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        textPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        inputPanel = new javax.swing.JPanel();
        studyLabel = new javax.swing.JLabel();
        moduleLabel = new javax.swing.JLabel();
        codeLabel = new javax.swing.JLabel();
        studyTextField = new javax.swing.JTextField();
        moduleTextField = new javax.swing.JTextField();
        codeTextField = new javax.swing.JTextField();
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(messages.getString("TatoolOnlineDialog.title"));
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        textPanel.setLayout(new java.awt.GridBagLayout());

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setText(messages.getString("TatoolOnlineDialog.label.enterCode"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        textPanel.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(15, 15, 15, 15);
        jPanel1.add(textPanel, gridBagConstraints);

        inputPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        inputPanel.setLayout(new java.awt.GridBagLayout());

        studyLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        studyLabel.setText(messages.getString("TatoolOnlineDialog.label.studyId"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.weightx = 1.0;
        inputPanel.add(studyLabel, gridBagConstraints);

        moduleLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        moduleLabel.setText(messages.getString("TatoolOnlineDialog.label.moduleNr"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.weightx = 1.0;
        inputPanel.add(moduleLabel, gridBagConstraints);

        codeLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        codeLabel.setText(messages.getString("TatoolOnlineDialog.label.code"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.weightx = 1.0;
        inputPanel.add(codeLabel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.weightx = 1.0;
        inputPanel.add(studyTextField, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        inputPanel.add(moduleTextField, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        inputPanel.add(codeTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 5, 15);
        jPanel1.add(inputPanel, gridBagConstraints);

        buttonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        okButton.setText(messages.getString("General.okLabel"));
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(okButton);

        cancelButton.setText(messages.getString("General.cancelLabel"));
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 10, 15);
        jPanel1.add(buttonPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

        private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        	dispose();
        }//GEN-LAST:event_cancelButtonActionPerformed

        private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        	validateInput();
        }//GEN-LAST:event_okButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel codeLabel;
    private javax.swing.JTextField codeTextField;
    private javax.swing.JPanel inputPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel moduleLabel;
    private javax.swing.JTextField moduleTextField;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel studyLabel;
    private javax.swing.JTextField studyTextField;
    private javax.swing.JPanel textPanel;
    // End of variables declaration//GEN-END:variables

}
