/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppUtils {
    private static Logger logger = LoggerFactory.getLogger(AppUtils.class);

    public static void setStartupProperty(String key, String value) {
        Properties properties = AppUtils.loadAppProperties();
        if (value != null) {
            properties.put(key, value);
        } else {
            properties.remove(key);
        }
        AppUtils.saveAppProperties(properties);
    }

    public static String getStartupProperty(String key, String defaultValue) {
        Properties properties = AppUtils.loadAppProperties();
        if (properties.containsKey(key)) {
            return properties.getProperty(key);
        }
        return defaultValue;
    }

    private static Properties loadAppProperties() {
        Properties properties = new Properties();
        File file = AppUtils.getStartupPropertiesFile();
        if ((file = file.getAbsoluteFile()).exists()) {
            try {
                FileInputStream is = new FileInputStream(file);
                properties.load(is);
                ((InputStream)is).close();
            }
            catch (IOException ioe) {
                logger.warn("Unable to read startup properties file", (Throwable)ioe);
            }
        }
        return properties;
    }

    private static void saveAppProperties(Properties properties) {
        File file = AppUtils.getStartupPropertiesFile();
        try {
            FileOutputStream os = new FileOutputStream(file);
            properties.store(os, "Tatool application startup properties");
            ((OutputStream)os).close();
        }
        catch (IOException ioe) {
            logger.warn("Unable to write startup properties file", (Throwable)ioe);
        }
    }

    private static File getStartupPropertiesFile() {
        return new File(".appStartupProperties.xml");
    }

    public static Object createInstance(String className, Class<?> targetClass, boolean failWithError) {
        if (className == null || className.length() < 1) {
            if (failWithError) {
                throw new RuntimeException("No class name to instantiate defined.");
            }
            return null;
        }
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (failWithError) {
                throw new RuntimeException(e);
            }
            return null;
        }
        if (c != null && !targetClass.isAssignableFrom(c)) {
            if (failWithError) {
                throw new RuntimeException("Provided class " + c.getName() + " is not of type " + targetClass.getName());
            }
            return null;
        }
        Object bean = null;
        if (c != null) {
            try {
                bean = c.newInstance();
            }
            catch (InstantiationException e) {
                if (failWithError) {
                    throw new RuntimeException(e);
                }
                return null;
            }
            catch (IllegalAccessException e) {
                if (failWithError) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        }
        return bean;
    }
}

