/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.UserAccountImpl;
import java.io.Serializable;
import java.util.Random;
import org.apache.commons.dbcp.BasicDataSource;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public class UserAccountDAO {
    private SessionFactory sessionFactory;

    public void loadAccount(UserAccountImpl userAccount) {
        if (userAccount.getId() != null) {
            this.sessionFactory.getCurrentSession().load((Object)userAccount, (Serializable)userAccount.getId());
        } else {
            Long id = new Random().nextLong();
            id = Math.abs(id);
            userAccount.setId(id);
            this.sessionFactory.getCurrentSession().save((Object)userAccount);
        }
    }

    public void saveAccount(UserAccountImpl account) {
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)account);
    }

    public void deleteAccount(UserAccountImpl account) {
        this.sessionFactory.getCurrentSession().delete((Object)account);
    }

    public void setAccountPassword(UserAccountImpl account, String password) {
        BasicDataSource dataSource = (BasicDataSource)SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory);
        String username = dataSource.getUsername();
        String newPassword = password != null ? password : "";
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER USER '").append(username).append("' SET PASSWORD '").append(newPassword).append("'");
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(sql.toString());
        query.executeUpdate();
        dataSource.setPassword(newPassword);
        account.setPassword(newPassword);
        account.setPasswordProtected(!newPassword.isEmpty());
    }

    public void shutdown() {
        String sql = "SHUTDOWN";
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(sql);
        query.executeUpdate();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

