/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.ModuleImpl;
import ch.tatool.app.data.ModuleSessionImpl;
import ch.tatool.app.data.TrialImpl;
import ch.tatool.app.data.UserAccountImpl;
import ch.tatool.app.service.impl.ModuleInfoImpl;
import ch.tatool.data.Module;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Query;
import org.hibernate.SessionFactory;

public class ModuleDAO {
    private SessionFactory sessionFactory;

    public Set<Module.Info> getModules(UserAccountImpl account) {
        Query query = this.sessionFactory.getCurrentSession().createQuery("select module.id, module.name FROM ModuleImpl as module where module.accountId = :accountId");
        query.setParameter("accountId", (Object)account.getId());
        List results = query.list();
        TreeSet<Module.Info> infos = new TreeSet<Module.Info>();
        for (Object[] result : results) {
            ModuleInfoImpl info = new ModuleInfoImpl();
            info.setAccount(account);
            info.setId((Long)result[0]);
            info.setName((String)result[1]);
            infos.add(info);
        }
        return infos;
    }

    public ModuleImpl loadModule(ModuleInfoImpl moduleInfo) {
        ModuleImpl module = (ModuleImpl)this.sessionFactory.getCurrentSession().get(ModuleImpl.class, (Serializable)moduleInfo.getId());
        if (!moduleInfo.getAccount().getId().equals(module.getAccountId())) {
            throw new RuntimeException("ModuleInfo and Module object don't belong to each other! Account id mismatch");
        }
        module.setAccount(moduleInfo.getAccount());
        return module;
    }

    public void deleteModule(ModuleInfoImpl moduleInfo) {
        List trialIds = this.sessionFactory.getCurrentSession().createQuery("select id from TrialImpl trial where trial.session.module.id = :id").setParameter("id", (Object)moduleInfo.getId()).list();
        for (Object o : trialIds) {
            TrialImpl trial = new TrialImpl();
            this.sessionFactory.getCurrentSession().load((Object)trial, (Serializable)((Long)o));
            this.sessionFactory.getCurrentSession().delete((Object)trial);
        }
        this.sessionFactory.getCurrentSession().flush();
        List sessionIds = this.sessionFactory.getCurrentSession().createQuery("select id from ModuleSessionImpl session where session.module.id = :id").setParameter("id", (Object)moduleInfo.getId()).list();
        for (Object o : sessionIds) {
            ModuleSessionImpl s = new ModuleSessionImpl();
            this.sessionFactory.getCurrentSession().load((Object)s, (Serializable)((Long)o));
            this.sessionFactory.getCurrentSession().delete((Object)s);
        }
        ModuleImpl module = this.loadModule(moduleInfo);
        this.sessionFactory.getCurrentSession().delete((Object)module);
    }

    public void addModuleProperties(ModuleImpl impl, Map<String, String> properties) {
        this.sessionFactory.getCurrentSession().update((Object)impl);
        Map<String, String> props = impl.getModuleProperties();
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            props.put(key, value);
        }
        this.sessionFactory.getCurrentSession().save((Object)impl);
    }

    public void saveModule(ModuleImpl module) {
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)module);
    }

    public void deleteModule(Module module) {
        this.sessionFactory.getCurrentSession().delete((Object)module);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

