/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.exec.impl;

import ch.tatool.app.service.exec.ExecutionService;
import ch.tatool.app.service.exec.PhaseListenerManager;
import ch.tatool.app.service.exec.impl.ExecutorImpl;
import ch.tatool.app.service.exec.impl.PhaseListenerManagerImpl;
import ch.tatool.app.util.AppUtils;
import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import ch.tatool.display.ExecutionDisplayProvider;
import ch.tatool.exec.Executor;
import ch.tatool.module.ExecutorInitializer;
import ch.tatool.module.ModuleScheduler;
import ch.tatool.module.ModuleSchedulerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionServiceImpl
implements ExecutionService {
    Logger logger = LoggerFactory.getLogger(ExecutionServiceImpl.class);
    private DataService dataService;
    private PhaseListenerManager phaseListenerManager = new PhaseListenerManagerImpl();

    @Override
    public boolean canExecute(Module module) {
        ModuleScheduler moduleScheduler = module.getModuleScheduler();
        if (moduleScheduler != null) {
            ModuleSchedulerMessage message = moduleScheduler.isSessionStartAllowed(module);
            return message.isSessionStartAllowed();
        }
        return true;
    }

    @Override
    public Executor createExecutor(Module module) {
        ExecutorImpl executor = new ExecutorImpl();
        executor.setExecutionServiceImpl(this);
        executor.setDataService(this.dataService);
        executor.setup(module);
        ExecutionDisplayProvider executionDisplayProvider = this.createExecutionDisplayProvider(executor, module);
        executor.setExecutionDisplayProvider(executionDisplayProvider);
        ExecutorInitializer initializer = module.getExecutorInitializer();
        if (initializer != null) {
            initializer.initialize((Executor)executor, module);
        }
        return executor;
    }

    private ExecutionDisplayProvider createExecutionDisplayProvider(Executor executor, Module module) {
        ExecutionDisplayProvider tmpProvider = null;
        String viewClass = (String)module.getModuleProperties().get("module.execution.display.classname");
        if (viewClass != null) {
            tmpProvider = (ExecutionDisplayProvider)AppUtils.createInstance(viewClass, ExecutionDisplayProvider.class, true);
            tmpProvider.setup(executor, module);
        } else {
            tmpProvider = (ExecutionDisplayProvider)AppUtils.createInstance("ch.tatool.core.display.swing.SwingExecutionDisplayProvider", ExecutionDisplayProvider.class, true);
            tmpProvider.setup(executor, module);
        }
        return tmpProvider;
    }

    @Override
    public void startExecution(Executor executor, boolean blockCallerThread) {
        ExecutorImpl e = (ExecutorImpl)executor;
        e.execute(blockCallerThread);
    }

    @Override
    public PhaseListenerManager getPhaseListenerManager() {
        return this.phaseListenerManager;
    }

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }
}

