/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.gui;

import ch.tatool.app.GuiController;
import ch.tatool.app.export.DataExportService;
import ch.tatool.app.gui.AboutDialog;
import ch.tatool.app.gui.ProgressDialog;
import ch.tatool.app.service.exec.ExecutionService;
import ch.tatool.app.util.AppUtils;
import ch.tatool.data.DataService;
import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhase;
import ch.tatool.exec.ExecutionPhaseListener;
import ch.tatool.exec.Executor;
import ch.tatool.export.DataExporter;
import ch.tatool.module.ModuleInfoProvider;
import ch.tatool.module.ModuleScheduler;
import ch.tatool.module.ModuleSchedulerMessage;
import ch.tatool.module.ModuleService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleOverviewFrame
extends JFrame
implements ExecutionPhaseListener {
    private static final long serialVersionUID = 8223517200199952504L;
    Logger logger = LoggerFactory.getLogger(ModuleOverviewFrame.class);
    private ModuleService moduleService;
    private DataService dataService;
    private DataExportService dataExportService;
    private ExecutionService executionService;
    private GuiController guiController;
    private ModuleInfoProvider moduleInfoProvider;
    private Module module;
    private Executor executor;
    private Map<String, DataExporter> exporters;
    private Date lastExportDate;
    private Messages messages;
    JPanel exportButtonPanel;
    JMenuItem manageTrainingsMenuItem;
    JPanel moduleInfoContainer;
    JButton startModuleButton;

    public ModuleOverviewFrame() {
        this.logger.info("Create new instance of ModuleOverviewFrame");
    }

    public void init() {
        this.executionService.getPhaseListenerManager().addExecutionPhaseListener((ExecutionPhaseListener)this, ExecutionPhase.EXECUTION_FINISH);
    }

    public void initialize(Module module) {
        this.module = module;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.startModuleButton);
        this.initializeModuleInfoProvider();
        this.updateUI();
        this.pack();
        this.setLocationRelativeTo(null);
        URL iconUrl = this.getClass().getResource("/ch/tatool/app/gui/icon.png");
        Image icon = this.getToolkit().getImage(iconUrl);
        this.setIconImage(icon);
    }

    private void initializeModuleInfoProvider() {
        String providerClass = (String)this.module.getModuleProperties().get("module.info.classname");
        if (providerClass != null) {
            ModuleInfoProvider infoProvider;
            this.moduleInfoProvider = infoProvider = (ModuleInfoProvider)AppUtils.createInstance(providerClass, ModuleInfoProvider.class, true);
            this.moduleInfoProvider.setModule(this.module);
        } else {
            this.moduleInfoProvider = null;
        }
        this.moduleInfoContainer.removeAll();
        if (this.moduleInfoProvider != null) {
            this.moduleInfoContainer.removeAll();
            this.moduleInfoContainer.add((Component)this.moduleInfoProvider.getModuleInfoPanel(), "Center");
            this.moduleInfoContainer.validate();
        } else {
            this.moduleInfoContainer.removeAll();
            this.moduleInfoContainer.validate();
        }
    }

    private void updateUI() {
        Map props = this.module.getModuleProperties();
        String moduleName = this.messages.getString("ModuleOverviewFrame.label.unknownModule");
        if (props.containsKey("module.name")) {
            moduleName = (String)props.get("module.name");
        }
        this.setTitle(this.messages.getString("General.title") + " - " + moduleName);
        this.initModuleExporters();
        if (this.moduleInfoProvider != null) {
            this.moduleInfoProvider.updateModuleInfo(this.module, this.lastExportDate);
        }
    }

    private void initModuleExporters() {
        this.exporters = this.module.getModuleExporters();
        this.exportButtonPanel.removeAll();
        if (this.exporters.size() > 0) {
            for (final String exporterKey : this.exporters.keySet()) {
                DataExporter ex = this.exporters.get(exporterKey);
                if (this.dataExportService.getLastExportDate(this.module, exporterKey) != null) {
                    if (this.lastExportDate == null) {
                        this.lastExportDate = this.dataExportService.getLastExportDate(this.module, exporterKey);
                    } else if (this.dataExportService.getLastExportDate(this.module, exporterKey).after(this.lastExportDate)) {
                        this.lastExportDate = this.dataExportService.getLastExportDate(this.module, exporterKey);
                    }
                }
                JButton exportButton = new JButton();
                exportButton.setFont(new Font("Tahoma", 0, 13));
                exportButton.setText(ex.getExporterName());
                exportButton.setMaximumSize(new Dimension(109, 25));
                exportButton.setMinimumSize(new Dimension(109, 25));
                exportButton.setPreferredSize(new Dimension(109, 25));
                exportButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ModuleOverviewFrame.this.exportData(exporterKey);
                    }
                });
                this.exportButtonPanel.add(exportButton);
            }
        }
        this.exportButtonPanel.validate();
    }

    public void setModuleManagementEnabled(boolean enabled) {
    }

    public void processExecutionPhase(ExecutionContext event) {
        switch (event.getPhase()) {
            case EXECUTION_FINISH: {
                this.moduleFinished();
            }
        }
    }

    private void moduleFinished() {
        if (this.module != null) {
            this.startModuleButton.setEnabled(true);
            this.updateUI();
            if (this.exporters != null) {
                for (String exporterKey : this.exporters.keySet()) {
                    DataExporter ex = this.exporters.get(exporterKey);
                    if (!ex.isAutoExport()) continue;
                    this.exportData(exporterKey);
                }
            }
        }
    }

    private void startModule() {
        ModuleScheduler moduleScheduler = this.module.getModuleScheduler();
        if (moduleScheduler != null) {
            ModuleSchedulerMessage message = moduleScheduler.isSessionStartAllowed(this.module);
            if (message.isSessionStartAllowed()) {
                this.startModuleButton.setEnabled(false);
                this.executor = this.executionService.createExecutor(this.module);
                this.executionService.startExecution(this.executor, false);
            } else {
                JOptionPane.showMessageDialog(this, message.getMessageText(), message.getMessageTitle(), 1);
            }
        } else {
            this.executor = this.executionService.createExecutor(this.module);
            this.executionService.startExecution(this.executor, false);
        }
    }

    private void exportData(final String exporterKey) {
        if (!this.dataExportService.containsPendingExportData(this.module, exporterKey)) {
            int result = JOptionPane.showConfirmDialog(this, this.messages.getString("ModuleOverviewFrame.label.confirmExport"), this.messages.getString("ModuleOverviewFrame.export.windowTitle"), 0);
            if (result != 0) {
                return;
            }
            this.module.getModuleProperties().put(exporterKey + "." + "last.session", "-1");
        }
        final ProgressDialog progressDialog = new ProgressDialog((Frame)this, true);
        progressDialog.setTitle(this.messages.getString("General.progress.label.pleaseWait"));
        progressDialog.setLabel(this.messages.getString("ModuleOverviewFrame.export.label.exportingData"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(true);
            }
        });
        new Thread(){

            @Override
            public void run() {
                ModuleOverviewFrame.this.doExport(progressDialog, exporterKey);
            }
        }.start();
    }

    private void doExport(final ProgressDialog progressDialog, String exporterKey) {
        final String errorMessage = this.dataExportService.exportData(this, this.module, exporterKey);
        final Date exportDate = this.dataExportService.getLastExportDate(this.module, exporterKey);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModuleOverviewFrame.this.exportFinished(progressDialog, errorMessage, exportDate);
            }
        });
    }

    private void exportFinished(ProgressDialog progressDialog, String errorMessage, Date exportDate) {
        progressDialog.dispose();
        if (errorMessage != null) {
            JOptionPane.showMessageDialog(this, errorMessage, this.messages.getString("General.errorMessage.windowTitle.error"), 0);
        }
        if (exportDate != null && this.moduleInfoProvider != null) {
            this.moduleInfoProvider.updateModuleInfo(this.module, exportDate);
        }
        if (errorMessage == null) {
            JOptionPane.showMessageDialog(this, this.messages.getString("ModuleOverviewFrame.export.label.exportSuccessful"), this.messages.getString("ModuleOverviewFrame.export.windowTitle"), 1);
        }
    }

    public ModuleService getModuleService() {
        return this.moduleService;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public ExecutionService getExecutionService() {
        return this.executionService;
    }

    public void setExecutionService(ExecutionService executionService) {
        this.executionService = executionService;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public GuiController getGuiController() {
        return this.guiController;
    }

    public void setGuiController(GuiController guiController) {
        this.guiController = guiController;
    }

    public DataExportService getDataExportService() {
        return this.dataExportService;
    }

    public void setDataExportService(DataExportService dataExportService) {
        this.dataExportService = dataExportService;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }

    private void manageTrainingsMenuItemActionPerformed(ActionEvent evt) {
        this.guiController.displayModuleManagerFrame();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.guiController.shutdown();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        AboutDialog aboutDialog = new AboutDialog((Frame)this, false);
        aboutDialog.setLocationRelativeTo(null);
        aboutDialog.setVisible(true);
    }

    private void initComponents() {
        this.getContentPane().removeAll();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.moduleInfoContainer = new JPanel();
        JPanel jPanel4 = new JPanel();
        JButton exitButton = new JButton();
        this.startModuleButton = new JButton();
        JLabel jLabel1 = new JLabel();
        this.exportButtonPanel = new JPanel();
        JMenuBar jMenuBar1 = new JMenuBar();
        JMenu jMenu1 = new JMenu();
        this.manageTrainingsMenuItem = new JMenuItem();
        JSeparator jSeparator1 = new JSeparator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu jMenu3 = new JMenu();
        JMenuItem helpMenuItem = new JMenuItem();
        JMenuItem aboutMenuItem = new JMenuItem();
        GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setTitle(this.messages.getString("General.title"));
        this.setMinimumSize(new Dimension(600, 350));
        jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.setPreferredSize(new Dimension(400, 400));
        this.moduleInfoContainer.setBorder(BorderFactory.createTitledBorder(""));
        this.moduleInfoContainer.setMinimumSize(new Dimension(633, 402));
        this.moduleInfoContainer.setPreferredSize(new Dimension(400, 400));
        this.moduleInfoContainer.setLayout(new BorderLayout());
        this.moduleInfoContainer.removeAll();
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moduleInfoContainer, -2, 418, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moduleInfoContainer, -2, 314, Short.MAX_VALUE));
        exitButton.setFont(new Font("Tahoma", 0, 13));
        exitButton.setText(this.messages.getString("ModuleOverviewFrame.label.exit"));
        exitButton.setMaximumSize(new Dimension(109, 25));
        exitButton.setMinimumSize(new Dimension(109, 25));
        exitButton.setPreferredSize(new Dimension(109, 25));
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleOverviewFrame.this.exitButtonActionPerformed(evt);
            }
        });
        this.startModuleButton.setFont(new Font("Tahoma", 0, 13));
        this.startModuleButton.setText(this.messages.getString("ModuleOverviewFrame.label.start"));
        this.startModuleButton.setMaximumSize(new Dimension(109, 25));
        this.startModuleButton.setMinimumSize(new Dimension(109, 25));
        this.startModuleButton.setPreferredSize(new Dimension(109, 25));
        this.startModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleOverviewFrame.this.startTrainingButtonActionPerformed(evt);
            }
        });
        jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/ch/tatool/app/gui/tatool.png")));
        this.exportButtonPanel.setLayout(new GridLayout(0, 1, 0, 5));
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel1, -1, 110, Short.MAX_VALUE).addGap(9, 9, 9)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.exportButtonPanel, -2, -1, -2).addGap(10, 10, 10)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(exitButton, -2, -1, -2).addContainerGap()).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.startModuleButton, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addGap(30, 30, 30).addComponent(this.startModuleButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportButtonPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(exitButton, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jPanel4, -2, -1, -2).addGap(10, 10, 10).addComponent(jPanel2, -1, 418, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jPanel4, -2, -1, -2).addContainerGap(178, Short.MAX_VALUE)).addComponent(jPanel2, -1, 314, Short.MAX_VALUE));
        this.getContentPane().add((Component)jPanel1, "Center");
        jMenu1.setText(this.messages.getString("ModuleOverviewFrame.labelMenu.file"));
        this.manageTrainingsMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.manageTrainingsMenuItem.setText(this.messages.getString("ModuleOverviewFrame.labelMenu.myModules"));
        this.manageTrainingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleOverviewFrame.this.manageTrainingsMenuItemActionPerformed(evt);
            }
        });
        jMenu1.add(this.manageTrainingsMenuItem);
        jMenu1.add(jSeparator1);
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        exitMenuItem.setText(this.messages.getString("ModuleOverviewFrame.labelMenu.exit"));
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleOverviewFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        jMenu1.add(exitMenuItem);
        jMenuBar1.add(jMenu1);
        jMenu3.setText(this.messages.getString("ModuleOverviewFrame.labelMenu.help"));
        helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpMenuItem.setText(this.messages.getString("ModuleOverviewFrame.labelMenu.helpTopics"));
        helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleOverviewFrame.this.helpMenuItemActionPerformed(evt);
            }
        });
        jMenu3.add(helpMenuItem);
        aboutMenuItem.setText(this.messages.getString("ModuleOverviewFrame.labelMenu.aboutTatool"));
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleOverviewFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        jMenu3.add(aboutMenuItem);
        jMenuBar1.add(jMenu3);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void startTrainingButtonActionPerformed(ActionEvent evt) {
        this.startModule();
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        this.guiController.shutdown();
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        Desktop desktop;
        if (!Desktop.isDesktopSupported()) {
            System.err.println(this.messages.getString("ModuleOverviewFrame.errorMessage.desktopError"));
            System.exit(1);
        }
        if (!(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            JOptionPane.showMessageDialog(this, this.messages.getString("ModuleOverviewFrame.errorMessage.desktopError2"));
        } else {
            try {
                URI uri = new URI("http://www.tatool.ch/faq.htm");
                desktop.browse(uri);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }
}

