/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.gui;

import ch.tatool.app.GuiController;
import ch.tatool.app.gui.CreateAccountFrame;
import ch.tatool.app.service.UserAccountException;
import ch.tatool.app.service.UserAccountService;
import ch.tatool.data.Messages;
import ch.tatool.data.UserAccount;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginFrame
extends JFrame {
    private static final long serialVersionUID = -8756830160634444342L;
    private static Logger logger = LoggerFactory.getLogger(LoginFrame.class);
    private UserAccountService userAccountService;
    private GuiController guiController;
    private DefaultComboBoxModel userComboBoxModel = new DefaultComboBoxModel();
    private CreateAccountFrame createAccountFrame;
    private Messages messages;
    private Properties appProps;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton loginButton;
    private JButton newAccountButton;
    private JComboBox usernameComboBox;

    public LoginFrame() {
        logger.info("Create new instance of LoginFrame");
    }

    public void init() {
        this.loadTatoolProperties();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.loginButton);
    }

    public void loadTatoolProperties() {
        this.appProps = new Properties();
        InputStream is = null;
        try {
            if (is == null) {
                is = this.getClass().getResourceAsStream("/ch/tatool/app/app.properties");
            }
            this.appProps.load(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperty("app.version", this.appProps.getProperty("app.version", "1.0"));
    }

    public void initialize() {
        this.initData();
        this.pack();
        Dimension size = this.getSize();
        size.height += 20;
        this.setSize(size);
        this.setLocationRelativeTo(null);
        URL iconUrl = this.getClass().getResource("/ch/tatool/app/gui/icon.png");
        Image icon = this.getToolkit().getImage(iconUrl);
        this.setIconImage(icon);
    }

    public void createAccount() {
        if (this.createAccountFrame == null) {
            this.createAccountFrame = new CreateAccountFrame();
            this.createAccountFrame.setMessages(this.messages);
            this.createAccountFrame.init();
            this.createAccountFrame.setUserAccountService(this.userAccountService);
            this.createAccountFrame.setLoginFrame(this);
        }
        this.createAccountFrame.initialize();
        this.createAccountFrame.setVisible(true);
    }

    public void loginAccount() {
        UserAccount account = null;
        boolean supportedVersion = false;
        UserAccount.Info info = (UserAccount.Info)this.userComboBoxModel.getSelectedItem();
        String currentVersion = this.appProps.getProperty("app.version", "1.0");
        String supportedVersionsString = this.appProps.getProperty("supported.versions", "");
        if (info != null) {
            if (currentVersion.equals(info.getVersion())) {
                supportedVersion = true;
            } else {
                String[] supportedVersions = supportedVersionsString.split(",");
                if (supportedVersions.length > 0) {
                    for (int i = 0; i < supportedVersions.length; ++i) {
                        if (!supportedVersions[i].equals(info.getVersion())) continue;
                        supportedVersion = true;
                    }
                }
            }
        }
        if (!supportedVersion) {
            JOptionPane.showMessageDialog(this, this.messages.getString("LoginFrame.errorMessage.wrongVersion"), this.messages.getString("General.errorMessage.windowTitle.warning"), 2);
            return;
        }
        account = this.loadAccount(this.userAccountService, info, this);
        if (account != null) {
            this.openAccount(account);
        }
    }

    public void openAccount(UserAccount account) {
        this.guiController.setUserAccount(account);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.createAccountFrame != null && this.createAccountFrame.isVisible()) {
            this.createAccountFrame.dispose();
            this.createAccountFrame = null;
        }
        super.setVisible(visible);
    }

    public UserAccount loadAccount(UserAccountService userAccountService, UserAccount.Info info, Component parent) {
        String password = null;
        try {
            UserAccount account = userAccountService.loadAccount(info, password);
            return account;
        }
        catch (RuntimeException e) {
            boolean isAccessDeniedException = false;
            for (Throwable tmp = e; tmp != null; tmp = tmp.getCause()) {
                if (tmp.getMessage().equals("Login failed.")) {
                    isAccessDeniedException = true;
                    break;
                }
                if (!tmp.getMessage().trim().equals("Startup failed. An encrypted database cannot be accessed without the correct boot password.")) continue;
                isAccessDeniedException = true;
                break;
            }
            if (isAccessDeniedException) {
                JOptionPane.showMessageDialog(parent, this.messages.getString("LoginFrame.errorMessage.wrongPassword"), this.messages.getString("General.errorMessage.windowTitle.warning"), 2);
                return null;
            }
            logger.error("unable to open account", (Throwable)e);
            JOptionPane.showMessageDialog(parent, this.messages.getString("LoginFrame.errorMessage.unknownProblem"), this.messages.getString("General.errorMessage.windowTitle.warning"), 0);
            this.writeToFile("tatool.log", LoginFrame.getStackTrace(e));
            throw new UserAccountException(e.getMessage(), e);
        }
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(String filename, String output) {
        BufferedWriter bufferedWriter = null;
        try {
            String userHome = System.getProperty("user.home");
            String sep = System.getProperty("file.separator");
            bufferedWriter = new BufferedWriter(new FileWriter(userHome + sep + filename));
            bufferedWriter.write(output);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void initData() {
        this.userComboBoxModel.removeAllElements();
        List<UserAccount.Info> accounts = this.userAccountService.getAccounts();
        for (UserAccount.Info a : accounts) {
            this.userComboBoxModel.addElement(a);
        }
    }

    public UserAccountService getUserAccountService() {
        return this.userAccountService;
    }

    public void setUserAccountService(UserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }

    public GuiController getGuiController() {
        return this.guiController;
    }

    public void setGuiController(GuiController guiController) {
        this.guiController = guiController;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.loginButton = new JButton();
        this.usernameComboBox = new JComboBox();
        this.newAccountButton = new JButton();
        this.setTitle(this.messages.getString("General.title") + " (v." + this.appProps.getProperty("app.version", "1.0") + ")");
        this.setMinimumSize(new Dimension(340, 135));
        this.setResizable(false);
        this.jPanel1.setPreferredSize(new Dimension(200, 142));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/ch/tatool/app/gui/UserGroup.png")));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, this.messages.getString("LoginFrame.labelTitle.user"), 0, 0, new Font("Tahoma", 1, 14)));
        this.loginButton.setText(this.messages.getString("General.okLabel"));
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginFrame.this.loginButtonActionPerformed(evt);
            }
        });
        this.usernameComboBox.setFont(new Font("Tahoma", 1, 14));
        this.usernameComboBox.setModel(this.userComboBoxModel);
        this.usernameComboBox.setMinimumSize(new Dimension(15, 18));
        this.usernameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginFrame.this.usernameComboBoxActionPerformed(evt);
            }
        });
        this.newAccountButton.setText(this.messages.getString("LoginFrame.label.createUser"));
        this.newAccountButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginFrame.this.newAccountButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.usernameComboBox, 0, 206, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.newAccountButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loginButton))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.usernameComboBox, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loginButton).addComponent(this.newAccountButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jLabel1, -2, 116, -2)).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 340, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void newAccountButtonActionPerformed(ActionEvent evt) {
        this.createAccount();
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        this.loginAccount();
    }

    private void usernameComboBoxActionPerformed(ActionEvent evt) {
    }
}

