/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.export;

import au.com.bytecode.opencsv.CSVWriter;
import ch.tatool.data.DataContainer;
import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.data.Trial;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVTrialDataExport {
    Logger logger = LoggerFactory.getLogger(CSVTrialDataExport.class);
    private DataService dataService;
    private List<String> baseProperties;
    private int basePropertiesSize;
    private List<String> sessionProperties;
    private List<String> trialProperties;
    private int trialPropertiesSize;
    private boolean useTrialShortNames = false;
    private boolean useSessionShortNames = false;
    private char separator = (char)59;

    public CSVTrialDataExport(DataService dataService) {
        this.dataService = dataService;
    }

    public File exportData(Module module, int fromSessionIndex) {
        this.initBaseProperties(module);
        this.initTrialProperties(module);
        try {
            File tmpFile = File.createTempFile("trialData", "csv");
            FileOutputStream fos = new FileOutputStream(tmpFile, false);
            CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"), this.separator);
            ArrayList<String> headers = new ArrayList<String>(this.baseProperties);
            HashSet<String> trialPropertiesShort = new HashSet<String>();
            for (String name : this.trialProperties) {
                String newName = "trial.";
                String[] nameParts = name.split("\\.");
                if (nameParts.length > 1) {
                    newName = newName + nameParts[nameParts.length - 2] + ".";
                }
                newName = newName + nameParts[nameParts.length - 1];
                trialPropertiesShort.add(newName);
            }
            if (trialPropertiesShort.size() == this.trialProperties.size()) {
                this.useTrialShortNames = true;
                this.trialProperties.clear();
                this.trialProperties.addAll(trialPropertiesShort);
                Collections.sort(this.trialProperties, String.CASE_INSENSITIVE_ORDER);
                headers.addAll(this.trialProperties);
            } else {
                Collections.sort(this.trialProperties, String.CASE_INSENSITIVE_ORDER);
                headers.addAll(this.trialProperties);
            }
            writer.writeNext(headers.toArray(new String[headers.size()]));
            List sessions = this.dataService.getSessions(module);
            for (ModuleSession session : sessions) {
                if (fromSessionIndex >= 0 && session.getIndex() < fromSessionIndex) continue;
                List trials = this.dataService.getTrials(session);
                for (Trial trial : trials) {
                    List<String[]> trialData = this.getDataForTrial(session, trial);
                    writer.writeAll(trialData);
                }
            }
            writer.close();
            return tmpFile;
        }
        catch (IOException ioe) {
            this.logger.error("Unable to write csv file", (Throwable)ioe);
            return null;
        }
    }

    private List<String[]> getDataForTrial(ModuleSession session, Trial trial) {
        ArrayList<String[]> data = new ArrayList<String[]>(this.basePropertiesSize + this.trialPropertiesSize);
        this.addTrialProperties(session, trial, data);
        return data;
    }

    private void initBaseProperties(Module module) {
        this.baseProperties = new ArrayList<String>();
        this.baseProperties.add("user.name");
        this.baseProperties.add("user.yearOfBirth");
        this.baseProperties.add("user.sex");
        this.baseProperties.add("user.osName");
        this.baseProperties.add("module.name");
        this.baseProperties.add("module.version");
        Map moduleProperties = module.getModuleProperties();
        if (moduleProperties.containsKey("tatool.online.subject.code")) {
            this.baseProperties.add("module.online.subject.code");
        }
        if (moduleProperties.containsKey("tatool.online.study.id")) {
            this.baseProperties.add("module.online.study.id");
        }
        if (moduleProperties.containsKey("tatool.online.module.nr")) {
            this.baseProperties.add("module.online.module.nr");
        }
        if (moduleProperties.containsKey("tatool.online.group.nr")) {
            this.baseProperties.add("module.online.group.nr");
        }
        this.baseProperties.add("session.id");
        this.baseProperties.add("session.index");
        this.baseProperties.add("session.startTime");
        this.baseProperties.add("session.endTime");
        this.baseProperties.add("session.completed");
        this.addSessionBaseProperties(module);
        this.baseProperties.add("trial.id");
        this.baseProperties.add("trial.index");
        this.baseProperties.add("trial.name");
        this.basePropertiesSize = this.baseProperties.size();
    }

    private void addSessionBaseProperties(Module module) {
        this.sessionProperties = this.getAllSessionPropertyNames(module);
        HashSet<String> sessionPropertiesShort = new HashSet<String>();
        for (String name : this.sessionProperties) {
            String newName = "session.";
            String[] nameParts = name.split("\\.");
            if (nameParts.length > 1) {
                newName = newName + nameParts[nameParts.length - 2] + ".";
            }
            newName = newName + nameParts[nameParts.length - 1];
            sessionPropertiesShort.add(newName);
        }
        if (sessionPropertiesShort.size() == this.sessionProperties.size()) {
            this.useSessionShortNames = true;
            this.sessionProperties.clear();
            this.sessionProperties.addAll(sessionPropertiesShort);
            Collections.sort(this.sessionProperties, String.CASE_INSENSITIVE_ORDER);
            this.baseProperties.addAll(this.sessionProperties);
        } else {
            Collections.sort(this.sessionProperties, String.CASE_INSENSITIVE_ORDER);
            this.baseProperties.addAll(this.sessionProperties);
        }
    }

    private String[] getBaseProperties(ModuleSession session, Trial trial) {
        ArrayList<String> baseProps = new ArrayList<String>();
        baseProps.add(session.getModule().getUserAccount().getName());
        Map accountProperties = session.getModule().getUserAccount().getProperties();
        baseProps.add((String)accountProperties.get("yearOfBirth"));
        baseProps.add((String)accountProperties.get("sex"));
        baseProps.add((String)accountProperties.get("osName"));
        Map moduleProperties = session.getModule().getModuleProperties();
        baseProps.add(session.getModule().getName());
        if (!((String)moduleProperties.get("module.version")).equals(null)) {
            baseProps.add((String)moduleProperties.get("module.version"));
        } else {
            baseProps.add("");
        }
        if (moduleProperties.containsKey("tatool.online.subject.code")) {
            baseProps.add((String)moduleProperties.get("tatool.online.subject.code"));
        }
        if (moduleProperties.containsKey("tatool.online.study.id")) {
            baseProps.add((String)moduleProperties.get("tatool.online.study.id"));
        }
        if (moduleProperties.containsKey("tatool.online.module.nr")) {
            baseProps.add((String)moduleProperties.get("tatool.online.module.nr"));
        }
        if (moduleProperties.containsKey("tatool.online.group.nr")) {
            baseProps.add((String)moduleProperties.get("tatool.online.group.nr"));
        }
        baseProps.add(session.getId().toString());
        baseProps.add(session.getIndex() + "");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        StringBuilder sessionStartTime = new StringBuilder("");
        StringBuilder sessionEndTime = new StringBuilder("");
        if (session.getStartTime() != null) {
            sessionStartTime = new StringBuilder(dateformat.format(session.getStartTime()));
        }
        if (session.getEndTime() != null) {
            sessionEndTime = new StringBuilder(dateformat.format(session.getEndTime()));
        }
        baseProps.add(sessionStartTime.toString());
        baseProps.add(sessionEndTime.toString());
        baseProps.add(String.valueOf(session.getCompleted()));
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        for (DataContainer.Entry p : session.getEntries()) {
            if (this.useSessionShortNames) {
                String newName = "session.";
                String[] nameParts = p.getNodeId().split("\\.");
                if (nameParts.length > 0) {
                    newName = newName + nameParts[nameParts.length - 1] + ".";
                }
                newName = newName + p.getName();
                propertyValues.put(newName, p.getValue());
                continue;
            }
            propertyValues.put(p.getNodeId() + "." + p.getName(), p.getValue());
        }
        for (String name : this.sessionProperties) {
            baseProps.add((String)propertyValues.get(name));
        }
        baseProps.add(trial.getId().toString());
        baseProps.add(trial.getIndex() + "");
        baseProps.add(trial.getParentId());
        return baseProps.toArray(new String[this.basePropertiesSize]);
    }

    private void addToData(List<String[]> data, String[] values) {
        if (values != null) {
            data.add(values);
        }
    }

    private void initTrialProperties(Module module) {
        this.trialProperties = this.getAllTrialPropertyNames(module);
        this.trialPropertiesSize = this.trialProperties.size();
    }

    private List<String> getAllTrialPropertyNames(Module module) {
        List trialProperties = this.dataService.findDistinctTrialPropertyNames(module);
        ArrayList<String> props = new ArrayList<String>();
        for (Object[] o : trialProperties) {
            StringBuilder sb = new StringBuilder();
            int len = o.length;
            for (int x = 0; x < len; ++x) {
                if (x > 0) {
                    sb.append('.');
                }
                sb.append(o[x]);
            }
            props.add(sb.toString());
        }
        return props;
    }

    private List<String> getAllSessionPropertyNames(Module module) {
        List sessionProperties = this.dataService.findDistinctSessionPropertyNames(module);
        ArrayList<String> props = new ArrayList<String>();
        for (Object[] o : sessionProperties) {
            StringBuilder sb = new StringBuilder();
            int len = o.length;
            for (int x = 0; x < len; ++x) {
                if (x > 0) {
                    sb.append('.');
                }
                sb.append(o[x]);
            }
            props.add(sb.toString());
        }
        return props;
    }

    private void addTrialProperties(ModuleSession session, Trial trial, List<String[]> data) {
        ArrayList<String> trialProps = null;
        trialProps = new ArrayList<String>();
        trialProps.addAll(Arrays.asList(this.getBaseProperties(session, trial)));
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        for (DataContainer.Entry p : trial.getEntries()) {
            if (this.useTrialShortNames) {
                String newName = "trial.";
                String[] nameParts = p.getNodeId().split("\\.");
                if (nameParts.length > 0) {
                    newName = newName + nameParts[nameParts.length - 1] + ".";
                }
                newName = newName + p.getName();
                propertyValues.put(newName, p.getValue());
                continue;
            }
            propertyValues.put(p.getNodeId() + "." + p.getName(), p.getValue());
        }
        for (String name : this.trialProperties) {
            trialProps.add((String)propertyValues.get(name));
        }
        this.addToData(data, trialProps.toArray(new String[trialProps.size()]));
    }

    public void setCSVParameters(char separator) {
        this.separator = separator;
    }
}

