/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ScoreOverviewPanel.java
 *
 * Created on 07.04.2011, 20:12:58
 */

package ch.tatool.app.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;

import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.module.ModuleInfoProvider;
import ch.tatool.module.ModuleScheduler;

/**
 *
 * @author Andre Locher
 */
public class ModuleInfoPanel extends javax.swing.JPanel implements ModuleInfoProvider {

	private static final long serialVersionUID = -3139781440101816327L;
	
	private HTMLEditorKit kit;
	
	private Module module;
	private String baseString;
	private String page;
	private String user;
	private Date lastExportDate;
    
    /** Creates new form ScoreOverviewPanel */
    public ModuleInfoPanel() {
        kit = new HTMLEditorKit();
        initComponents();
    }
    
    /**
     * Displays a HTML String in the editor pane.
     * 
     * @param htmlString the HTML string to display
     */
    public void setHTMLString(String htmlString) {
        URL base = getClass().getResource(baseString);
        ((javax.swing.text.html.HTMLDocument)jEditorPane.getDocument()).setBase(base);
        jEditorPane.setText(htmlString);
        this.validate();
    }

    /**
     * Displays a HTML URL in the editor pane.
     * 
     * @param url the url to display
     */
    public void setHTMLPage(URL url) {
    	Document doc = kit.createDefaultDocument();
        jEditorPane.setDocument(doc);
        try {
			jEditorPane.setPage(url);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane = new javax.swing.JScrollPane();
        jEditorPane = new javax.swing.JEditorPane();

        setLayout(new java.awt.GridLayout(1, 1, 1, 0));

        jScrollPane.setBorder(null);

        jEditorPane.setBorder(null);
        jEditorPane.setEditable(false);
        jEditorPane.setEditorKit(kit);
        jEditorPane.setFocusable(false);
        jScrollPane.setViewportView(jEditorPane);

        add(jScrollPane);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JEditorPane jEditorPane;
    private javax.swing.JScrollPane jScrollPane;
    // End of variables declaration//GEN-END:variables

	public JPanel getModuleInfoPanel() {
		Map<String, String> moduleProperties = module.getModuleProperties();
		if (moduleProperties.containsKey(Module.PROPERTY_MODULE_INFO_BASE)) {
			baseString = moduleProperties.get(Module.PROPERTY_MODULE_INFO_BASE);
		} else {
			baseString = "/ch/tatool/app/gui/";
		}
		if (moduleProperties.containsKey(Module.PROPERTY_MODULE_INFO_PAGE)) {
			page = moduleProperties.get(Module.PROPERTY_MODULE_INFO_PAGE);
		} else {
			// get i18n support
			Messages messages = module.getMessages();
			if (messages.getLanguage().equals("de")) {
				page = "welcome_de.htm";
			} else {
				page = "welcome.htm";
			}
		}
		updateModuleInfo(module, null);
		
		return this;
	}
	
	public String replaceVariables(String html) {
		
		// get i18n support
		Messages messages = module.getMessages();
		
		// replace user variable with current user
		if (html.indexOf("$user") != -1) {
			user = module.getUserAccount().getName();
			html = html.replaceAll("\\$user", String.valueOf(user));
		}
		
		// replace module name
		if (html.indexOf("$moduleName") != -1) {
			StringBuilder sb = new StringBuilder();
			sb.append("<b>");
			sb.append(messages.getString("ModuleInfoPanel.label.moduleName"));
			sb.append("</b> ");
			sb.append(module.getName());
			html = html.replaceAll("\\$moduleName", sb.toString());
		}
		
		// get information from the module scheduler
		ModuleScheduler moduleScheduler = module.getModuleScheduler();
		if (moduleScheduler != null) {
			String numSessions = moduleScheduler.getSchedulerNumSessions(module);
			String lastSessionDate = moduleScheduler.getSchedulerLastSessionDate(module);
			
			// number of sessions
			StringBuilder sb = new StringBuilder();
			sb.append("<b>");
			sb.append(messages.getString("ModuleInfoPanel.label.numSessions"));
			sb.append("</b> ");
			sb.append(" " + "<span class='highlight_red'>");
			sb.append(String.valueOf(numSessions));
			sb.append("</span>");		
			html = html.replaceAll("\\$numSessions", sb.toString());
			
			// last session date
			StringBuilder sb2 = new StringBuilder();
			sb2.append("<b>");
			sb2.append(messages.getString("ModuleInfoPanel.label.lastSession"));
			sb2.append("</b> ");
			sb2.append(String.valueOf(lastSessionDate));
			html = html.replaceAll("\\$lastSessionDate", sb2.toString());
		}
		
		// get information about last export date
		StringBuilder sb = new StringBuilder();
		sb.append("<b>");
		sb.append(messages.getString("ModuleInfoPanel.label.lastExport"));
		sb.append("</b> ");
		if (lastExportDate != null) {
			DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
			sb.append(dateFormat.format(lastExportDate));
		} else {
			sb.append("-");
		}
		html = html.replaceAll("\\$lastExportDate", sb.toString());
		
		return html;
	}

	private String getHTMLString(String page) {
		InputStream is = getClass().getResourceAsStream(baseString + page);
		String html = "";
		try {
			html = inputStreamToString(is);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return html;
	}
	
	private String inputStreamToString(InputStream in) throws IOException {
		BufferedReader bufferedReader = new BufferedReader(
				new InputStreamReader(in));
		StringBuilder stringBuilder = new StringBuilder();
		String line = null;

		while ((line = bufferedReader.readLine()) != null) {
			stringBuilder.append(line + "\n");
		}

		bufferedReader.close();
		return stringBuilder.toString();
	}

	public void updateModuleInfo(Module module, Date lastExportDate) {
		this.lastExportDate = lastExportDate;
		String html = getHTMLString(page);
		html = replaceVariables(html);
		setHTMLString(html);
	}
	
	public void setModule(Module module) {
		this.module = module;
	}

}
