/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjssr.v8renderer;

import ch.swaechter.angularjssr.renderer.assets.RenderAssetProvider;
import ch.swaechter.angularjssr.renderer.engine.RenderEngine;
import ch.swaechter.angularjssr.renderer.queue.RenderQueue;
import ch.swaechter.angularjssr.renderer.queue.RenderRequest;
import ch.swaechter.angularjssr.renderer.queue.RenderResponse;
import com.eclipsesource.v8.NodeJS;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.utils.MemoryManager;
import java.util.Optional;

public class V8RenderEngine
implements RenderEngine {
    private MemoryManager memorymanager;
    private NodeJS nodejs;
    private V8Object renderer;
    private boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork(RenderQueue queue, RenderAssetProvider provider) {
        try {
            this.running = true;
            this.nodejs = NodeJS.createNodeJS();
            this.memorymanager = new MemoryManager(this.nodejs.getRuntime());
            this.nodejs.getRuntime().registerJavaMethod((object, parameters) -> {
                this.renderer = parameters.getObject(0);
            }, "registerRenderEngine");
            this.nodejs.getRuntime().registerJavaMethod((object, parameters) -> {
                String uuid = parameters.getString(0);
                String content = parameters.getString(1);
                queue.resolveRenderFuture(new RenderResponse(uuid, content));
            }, "receiveRenderedPage");
            this.nodejs.require(provider.getServerBundle()).release();
            while (this.running) {
                this.nodejs.handleMessage();
                Optional<RenderRequest> requestitem = queue.getNextRenderRequest();
                if (!requestitem.isPresent()) continue;
                RenderRequest request = requestitem.get();
                V8Array parameters2 = new V8Array(this.nodejs.getRuntime());
                try {
                    parameters2.push(request.getUuid());
                    parameters2.push(provider.getIndexContent());
                    parameters2.push(request.getUri());
                    this.renderer.executeVoidFunction("renderPage", parameters2);
                }
                finally {
                    parameters2.release();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (this.memorymanager != null) {
                this.memorymanager.release();
            }
            if (this.nodejs != null) {
                this.nodejs.release();
            }
        }
    }

    @Override
    public void stopWork() {
        this.running = false;
    }

    @Override
    public boolean isWorking() {
        return this.running;
    }
}

