/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjssr.renderer;

import ch.swaechter.angularjssr.renderer.assets.RenderAssetProvider;
import ch.swaechter.angularjssr.renderer.engine.RenderEngine;
import ch.swaechter.angularjssr.renderer.queue.RenderFuture;
import ch.swaechter.angularjssr.renderer.queue.RenderQueue;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Future;

public class Renderer {
    private final RenderQueue queue = new RenderQueue();
    private final RenderEngine engine;
    private final RenderAssetProvider provider;
    private Date reloaddate;

    public Renderer(RenderEngine engine, RenderAssetProvider provider) {
        this.engine = engine;
        this.provider = provider;
    }

    public void startEngine() {
        if (this.engine.isWorking()) {
            return;
        }
        this.reloaddate = new Date();
        new Thread(() -> this.engine.doWork(this.queue, this.provider)).start();
        new Thread(() -> this.checkAssets()).start();
    }

    public void stopEngine() {
        if (!this.engine.isWorking()) {
            return;
        }
        while (!this.queue.isQueuePending()) {
            this.sleep(50);
        }
        this.engine.stopWork();
    }

    public boolean isEngineRunning() {
        return this.engine.isWorking();
    }

    public Future<String> renderRequest(String uri) {
        RenderFuture future = this.queue.createRenderFuture(uri);
        return future.getCompletableFuture();
    }

    private void checkAssets() {
        try {
            if (this.provider.isLiveReloadSupported()) {
                while (this.engine.isWorking()) {
                    if (this.provider.isLiveReloadRequired(this.reloaddate)) {
                        this.stopEngine();
                        this.startEngine();
                    }
                    this.sleep(1000);
                }
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException("The renderer was unable to check if the resource assets have changed");
        }
    }

    private void sleep(int miliseconds) {
        try {
            Thread.sleep(miliseconds);
        }
        catch (Exception exception) {
            throw new IllegalStateException("An error occurred while working with the engine: " + exception.getMessage(), exception);
        }
    }
}

