/*
 * Decompiled with CFR 0.152.
 */
package ch.sbb.markdown2html.github;

import ch.sbb.markdown2html.github.model.MarkdownRequest;
import java.io.IOException;
import lombok.Generated;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class GitHubHttpClient {
    private static final String GITHUB_API_URL = "https://api.github.com/markdown";
    private static final String ACCEPT_HEADER = "application/vnd.github+json";
    private static final String API_VERSION_HEADER = "X-GitHub-Api-Version";
    private static final String API_VERSION = "2022-11-28";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String GFM = "gfm";
    private final String githubToken;

    public String convertMarkdownToHtml(String markdown) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(GITHUB_API_URL);
            httpPost.setHeader("Accept", (Object)ACCEPT_HEADER);
            httpPost.setHeader(API_VERSION_HEADER, (Object)API_VERSION);
            if (this.githubToken != null && !this.githubToken.isEmpty()) {
                httpPost.setHeader(AUTHORIZATION_HEADER, (Object)("Bearer " + this.githubToken));
            }
            MarkdownRequest markdownRequest = new MarkdownRequest(GFM, markdown);
            httpPost.setEntity((HttpEntity)new StringEntity(markdownRequest.toJSON()));
            String string = this.executeRequest(httpClient, httpPost);
            return string;
        }
    }

    private String executeRequest(CloseableHttpClient httpClient, HttpPost httpPost) throws IOException {
        HttpClientResponseHandler responseHandler = response -> {
            int statusCode = response.getCode();
            if (statusCode == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            throw new IllegalStateException("HTTP request failed with status: " + statusCode);
        };
        return (String)httpClient.execute((ClassicHttpRequest)httpPost, responseHandler);
    }

    @Generated
    public GitHubHttpClient(String githubToken) {
        this.githubToken = githubToken;
    }
}

