/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.test.actionmatcher.base.exception;

import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;

public class ActionAssertionError
extends ComparisonFailure {
    private static final int FACTORY_METHOD_STACK_TRACE_LEVELS_TO_REMOVE = 2;
    private static final Pattern EXECUTE_PARAM_PATTERN = Pattern.compile("(?<=\\().*(?=\\))", 32);
    private int stackTraceLevelsToRemove;

    private ActionAssertionError(String message, String expected, String actual, int stackTraceLevelsToRemove) {
        super(message, expected, actual);
        this.stackTraceLevelsToRemove = stackTraceLevelsToRemove;
    }

    private ActionAssertionError(String message, ComparisonFailure cause, int stackTraceLevelsToRemove) {
        this(message, ActionAssertionError.extractExecuteParam(cause.getExpected()), ActionAssertionError.extractExecuteParam(cause.getActual()), stackTraceLevelsToRemove);
    }

    public void printStackTrace(PrintWriter s) {
        StackTraceElement[] originTrace = this.getStackTrace();
        if (originTrace != null && originTrace.length >= this.stackTraceLevelsToRemove) {
            StackTraceElement[] reducedTrace = new StackTraceElement[originTrace.length - this.stackTraceLevelsToRemove];
            System.arraycopy(originTrace, this.stackTraceLevelsToRemove, reducedTrace, 0, originTrace.length - this.stackTraceLevelsToRemove);
            this.setStackTrace(reducedTrace);
        }
        super.printStackTrace(s);
    }

    public static ActionAssertionError wrongActionParams(ComparisonFailure error) {
        return ActionAssertionError.wrongActionParams(error, 2);
    }

    public static ActionAssertionError wrongActionParams(ComparisonFailure error, int stackTraceLevelsToRemove) {
        return new ActionAssertionError("Action is executed using wrong params.", error, ++stackTraceLevelsToRemove);
    }

    public static ActionAssertionError missingActionExecution() {
        return ActionAssertionError.missingActionExecution(2);
    }

    public static ActionAssertionError missingActionExecution(int stackTraceLevelsToRemove) {
        return new ActionAssertionError("Action was not executed.", "<action was executed>", "<action was not executed>", ++stackTraceLevelsToRemove);
    }

    private static String extractExecuteParam(String error) {
        Matcher matcher = EXECUTE_PARAM_PATTERN.matcher(error);
        if (matcher.find()) {
            return matcher.group().trim();
        }
        return error;
    }
}

