/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.test.actionmatcher.base;

import ch.puzzle.libpuzzle.springframework.boot.rest.CrudActions;
import org.mockito.Mockito;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public abstract class CrudActionConfigurer<TCrudActions extends CrudActions, TAction>
implements MockMvcConfigurer {
    protected final TCrudActions crudActions;
    private final TAction action;

    protected CrudActionConfigurer(TCrudActions crudActions) {
        this.crudActions = crudActions;
        this.action = this.createAction(crudActions);
    }

    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        this.mockCrudActions(this.crudActions, this.action);
        return request -> {
            request.setAttribute(this.getClass().getName(), this.action);
            return request;
        };
    }

    private TAction createAction(TCrudActions crudActions) {
        return Mockito.mockingDetails(crudActions).isSpy() ? this.createActionSpy(crudActions) : this.createActionMock(crudActions);
    }

    private TAction createActionSpy(TCrudActions crudActions) {
        TAction action = this.createActionSpy();
        Mockito.reset((Object[])new CrudActions[]{crudActions});
        return action;
    }

    private TAction createActionMock(TCrudActions crudActions) {
        TAction action = this.createActionMock();
        Mockito.reset((Object[])new CrudActions[]{crudActions});
        return action;
    }

    protected abstract TAction createActionMock();

    protected abstract TAction createActionSpy();

    protected abstract void mockCrudActions(TCrudActions var1, TAction var2);
}

