/*
 * Decompiled with CFR 0.152.
 */
package ch.puzzle.libpuzzle.springframework.boot.rest.test.actionmatcher.base;

import ch.puzzle.libpuzzle.springframework.boot.rest.test.actionmatcher.base.ActionMatchers;
import ch.puzzle.libpuzzle.springframework.boot.rest.test.actionmatcher.base.exception.InvalidMatcherConfigDetected;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ActionResult
implements MvcResult {
    private final MvcResult inner;

    public ActionResult(MvcResult inner) {
        this.inner = inner;
    }

    public <TAction> TAction action(ActionMatchers<TAction> matcher) {
        Object action = this.getRequest().getAttribute(matcher.configurer().getName());
        if (null == action) {
            throw InvalidMatcherConfigDetected.actionNotFound(matcher.configurer());
        }
        try {
            return (TAction)action;
        }
        catch (ClassCastException e) {
            throw InvalidMatcherConfigDetected.actionNotSupported(action, e, matcher.configurer());
        }
    }

    public MockHttpServletRequest getRequest() {
        return this.inner.getRequest();
    }

    public MockHttpServletResponse getResponse() {
        return this.inner.getResponse();
    }

    public Object getHandler() {
        return this.inner.getHandler();
    }

    public HandlerInterceptor[] getInterceptors() {
        return this.inner.getInterceptors();
    }

    public ModelAndView getModelAndView() {
        return this.inner.getModelAndView();
    }

    public Exception getResolvedException() {
        return this.inner.getResolvedException();
    }

    public FlashMap getFlashMap() {
        return this.inner.getFlashMap();
    }

    public Object getAsyncResult() {
        return this.inner.getAsyncResult();
    }

    public Object getAsyncResult(long timeToWait) {
        return this.inner.getAsyncResult(timeToWait);
    }
}

