/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.util;

import com.google.api.client.http.UriTemplate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public final class URIBuilderUtil {
    public static URIBuilder create(String url) {
        try {
            return new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getLocalizedMessage());
        }
    }

    public static URIBuilder create(String url, Map<String, Object> pathParameters) {
        try {
            return new URIBuilder(UriTemplate.expand((String)url, pathParameters, (boolean)false));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getLocalizedMessage());
        }
    }

    public static URI build(URIBuilder uriBuilder) {
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getLocalizedMessage());
        }
    }

    public static URIBuilder applyQueryParam(URIBuilder uriBuilder, String paramName, Object paramValue) {
        uriBuilder = paramValue instanceof Collection ? URIBuilderUtil.applyCollection(uriBuilder, paramName, ((Collection)paramValue).toArray()) : (paramValue instanceof Object[] ? URIBuilderUtil.applyCollection(uriBuilder, paramName, (Object[])paramValue) : uriBuilder.addParameter(paramName, paramValue.toString()));
        return uriBuilder;
    }

    private static URIBuilder applyCollection(URIBuilder uriBuilder, String paramName, Object[] paramValues) {
        for (Object paramValue : paramValues) {
            uriBuilder.addParameter(paramName, paramValue.toString());
        }
        return uriBuilder;
    }
}

