/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.util;

import ch.postfinance.sdk.ErrorCode;
import ch.postfinance.sdk.exception.PostFinanceCheckoutSdkException;
import ch.postfinance.sdk.model.WebhookEncryptionPublicKey;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class EncryptionUtil {
    public static boolean isContentValid(String contentToVerify, String contentSignature, WebhookEncryptionPublicKey webhookEncryptionPublicKey, String encryptionProvider, String signatureAlgorithm) {
        PublicKey publicKey = EncryptionUtil.getPublicKey(webhookEncryptionPublicKey.getId(), Base64.getDecoder().decode(webhookEncryptionPublicKey.getPublicKey()), encryptionProvider, signatureAlgorithm);
        Signature verifier = EncryptionUtil.getSignature(signatureAlgorithm);
        try {
            verifier.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_GENERAL_ERROR, "Could not verify content due to public key issue: " + e.getLocalizedMessage());
        }
        try {
            verifier.update(contentToVerify.getBytes(StandardCharsets.UTF_8));
        }
        catch (SignatureException e) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_GENERAL_ERROR, "Could not verify content due to verifier issue: " + e.getLocalizedMessage());
        }
        try {
            return verifier.verify(Base64.getDecoder().decode(contentSignature));
        }
        catch (SignatureException e) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_GENERAL_ERROR, "Could not verify content due to unknown issue: " + e.getLocalizedMessage());
        }
    }

    private static PublicKey getPublicKey(String publicKeyId, byte[] publicKeyBytes, String encryptionProvider, String signatureAlgorithm) {
        try {
            return KeyFactory.getInstance(EncryptionUtil.getPublicKeyAlgorithm(signatureAlgorithm), encryptionProvider).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        }
        catch (InvalidKeySpecException e) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_UNKNOWN_ALGORITHM, "Invalid public key with ID: " + publicKeyId);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_UNKNOWN_ALGORITHM, "Unknown webhook signature encryption algorithm: " + signatureAlgorithm);
        }
        catch (NoSuchProviderException e) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_UNKNOWN_PROVIDER, "Unknown webhook signature encryption provider: " + encryptionProvider);
        }
    }

    private static Signature getSignature(String signatureAlgorithm) {
        try {
            return Signature.getInstance(signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_UNKNOWN_ALGORITHM, "Unknown signature algorithm: " + signatureAlgorithm);
        }
    }

    private static String getPublicKeyAlgorithm(String signatureAlgorithm) {
        String publicKeyAlgorithm;
        switch (signatureAlgorithm) {
            case "SHA256withECDSA": {
                publicKeyAlgorithm = "ECDSA";
                break;
            }
            default: {
                throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_UNKNOWN_ALGORITHM, "Unknown webhook signature encryption algorithm: " + signatureAlgorithm);
            }
        }
        return publicKeyAlgorithm;
    }
}

