/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.ErrorCode;
import ch.postfinance.sdk.exception.PostFinanceCheckoutSdkException;
import ch.postfinance.sdk.model.WebhookEncryptionPublicKey;
import ch.postfinance.sdk.util.EncryptionUtil;
import ch.postfinance.sdk.util.URIBuilderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URIBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class WebhookEncryptionService {
    private static final Map<String, WebhookEncryptionPublicKey> cache = new ConcurrentHashMap<String, WebhookEncryptionPublicKey>();
    private ApiClient apiClient;

    public WebhookEncryptionService(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public WebhookEncryptionPublicKey read(String id) throws IOException {
        HttpResponse response = this.readForHttpResponse(id);
        String returnType = "WebhookEncryptionPublicKey";
        if (returnType.equals("String")) {
            return (WebhookEncryptionPublicKey)((Object)response.parseAsString());
        }
        TypeReference<WebhookEncryptionPublicKey> typeRef = new TypeReference<WebhookEncryptionPublicKey>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (WebhookEncryptionPublicKey)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public WebhookEncryptionPublicKey read(String id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.readForHttpResponse(id, params);
        String returnType = "WebhookEncryptionPublicKey";
        if (returnType.equals("String")) {
            return (WebhookEncryptionPublicKey)((Object)response.parseAsString());
        }
        TypeReference<WebhookEncryptionPublicKey> typeRef = new TypeReference<WebhookEncryptionPublicKey>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (WebhookEncryptionPublicKey)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse readForHttpResponse(String id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/webhook-encryption/read");
        if (id != null) {
            String key = "id";
            String value = id;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse readForHttpResponse(String id, Map<String, Object> params) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/webhook-encryption/read");
        HashMap<String, String> allParams = params == null ? new HashMap<String, String>() : new HashMap<String, Object>(params);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public boolean isContentValid(String signatureHeader, String contentToVerify, String encryptionProviderName) {
        String regex = "^algorithm=([a-zA-Z0-9]+),\\skeyId=([a-z0-9\\-]+),\\s{1}signature=([a-zA-Z0-9+\\/=]+)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(signatureHeader);
        if (matcher.matches()) {
            WebhookEncryptionPublicKey publicKey;
            String signatureAlgorithm = matcher.group(1);
            String publicKeyId = matcher.group(2);
            String contentSignature = matcher.group(3);
            if (cache.containsKey(publicKeyId)) {
                publicKey = cache.get(publicKeyId);
            } else {
                try {
                    publicKey = this.read(publicKeyId);
                }
                catch (IOException e) {
                    throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_GENERAL_ERROR, "Could not retrieve public key with ID: " + publicKeyId);
                }
                catch (PostFinanceCheckoutSdkException e) {
                    if (e.getCode() == ErrorCode.ENTITY_NOT_FOUND) {
                        throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_PUBLIC_KEY_UNKNOWN, "Unknown public key with ID: " + publicKeyId);
                    }
                    throw e;
                }
                cache.put(publicKey.getId(), publicKey);
            }
            return EncryptionUtil.isContentValid(contentToVerify, contentSignature, publicKey, encryptionProviderName, signatureAlgorithm);
        }
        throw new PostFinanceCheckoutSdkException(ErrorCode.WEBHOOK_ENCRYPTION_SIGNATURE_HEADER_INVALID, "Invalid webhook signature header. Expected format: 'algorithm=<algorithm>, keyId=<keyId>, signature=<signature>'");
    }

    public boolean isContentValid(String signatureHeader, String contentToVerify) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        return this.isContentValid(signatureHeader, contentToVerify, "BC");
    }

    private boolean isNoBodyResponse(HttpResponse response) throws IOException {
        InputStream content = response.getContent();
        return content.available() == 0;
    }
}

