/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.ErrorCode;
import ch.postfinance.sdk.exception.PostFinanceCheckoutSdkException;
import ch.postfinance.sdk.model.WebAppConfirmationRequest;
import ch.postfinance.sdk.model.WebAppConfirmationResponse;
import ch.postfinance.sdk.util.URIBuilderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

public class WebAppService {
    private ApiClient apiClient;

    public WebAppService(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public Boolean checkInstallation(Long spaceId) throws IOException {
        HttpResponse response = this.checkInstallationForHttpResponse(spaceId);
        String returnType = "Boolean";
        if (returnType.equals("String")) {
            return (Boolean)((Object)response.parseAsString());
        }
        TypeReference<Boolean> typeRef = new TypeReference<Boolean>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Boolean)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Boolean checkInstallation(Long spaceId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.checkInstallationForHttpResponse(spaceId, params);
        String returnType = "Boolean";
        if (returnType.equals("String")) {
            return (Boolean)((Object)response.parseAsString());
        }
        TypeReference<Boolean> typeRef = new TypeReference<Boolean>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Boolean)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse checkInstallationForHttpResponse(Long spaceId) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling checkInstallation");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/web-app/check-installation");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse checkInstallationForHttpResponse(Long spaceId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling checkInstallation");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/web-app/check-installation");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public WebAppConfirmationResponse confirm(WebAppConfirmationRequest request) throws IOException {
        HttpResponse response = this.confirmForHttpResponse(request);
        String returnType = "WebAppConfirmationResponse";
        if (returnType.equals("String")) {
            return (WebAppConfirmationResponse)((Object)response.parseAsString());
        }
        TypeReference<WebAppConfirmationResponse> typeRef = new TypeReference<WebAppConfirmationResponse>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (WebAppConfirmationResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public WebAppConfirmationResponse confirm(WebAppConfirmationRequest request, Map<String, Object> params) throws IOException {
        HttpResponse response = this.confirmForHttpResponse(request, params);
        String returnType = "WebAppConfirmationResponse";
        if (returnType.equals("String")) {
            return (WebAppConfirmationResponse)((Object)response.parseAsString());
        }
        TypeReference<WebAppConfirmationResponse> typeRef = new TypeReference<WebAppConfirmationResponse>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (WebAppConfirmationResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse confirmForHttpResponse(WebAppConfirmationRequest request) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("Missing the required parameter 'request' when calling confirm");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/web-app/confirm");
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, request);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse confirmForHttpResponse(InputStream request, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (request == null) {
            throw new IllegalArgumentException("Missing the required parameter 'request' when calling confirm");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/web-app/confirm");
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        if (request == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, request);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse confirmForHttpResponse(WebAppConfirmationRequest request, Map<String, Object> params) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("Missing the required parameter 'request' when calling confirm");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/web-app/confirm");
        HashMap allParams = params == null ? new HashMap() : new HashMap<String, Object>(params);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, request);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public void uninstall(Long spaceId) throws IOException {
        this.uninstallForHttpResponse(spaceId);
    }

    public void uninstall(Long spaceId, Map<String, Object> params) throws IOException {
        this.uninstallForHttpResponse(spaceId, params);
    }

    public HttpResponse uninstallForHttpResponse(Long spaceId) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling uninstall");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/web-app/uninstall");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse uninstallForHttpResponse(Long spaceId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling uninstall");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/web-app/uninstall");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    private boolean isNoBodyResponse(HttpResponse response) throws IOException {
        InputStream content = response.getContent();
        return content.available() == 0;
    }
}

