/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.ErrorCode;
import ch.postfinance.sdk.exception.PostFinanceCheckoutSdkException;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.ShopifySubscription;
import ch.postfinance.sdk.model.ShopifySubscriptionCreationRequest;
import ch.postfinance.sdk.model.ShopifySubscriptionUpdateAddressesRequest;
import ch.postfinance.sdk.model.ShopifySubscriptionUpdateRequest;
import ch.postfinance.sdk.model.ShopifySubscriptionVersion;
import ch.postfinance.sdk.util.URIBuilderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

public class ShopifySubscriptionService {
    private ApiClient apiClient;

    public ShopifySubscriptionService(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public Long count(Long spaceId, EntityQueryFilter filter) throws IOException {
        HttpResponse response = this.countForHttpResponse(spaceId, filter);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Long count(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.countForHttpResponse(filter, spaceId, params);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse countForHttpResponse(Long spaceId, EntityQueryFilter filter) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/count");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(Long spaceId, InputStream filter, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/count");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        if (filter == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, filter);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/count");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public ShopifySubscriptionVersion create(Long spaceId, ShopifySubscriptionCreationRequest creationRequest) throws IOException {
        HttpResponse response = this.createForHttpResponse(spaceId, creationRequest);
        String returnType = "ShopifySubscriptionVersion";
        if (returnType.equals("String")) {
            return (ShopifySubscriptionVersion)((Object)response.parseAsString());
        }
        TypeReference<ShopifySubscriptionVersion> typeRef = new TypeReference<ShopifySubscriptionVersion>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ShopifySubscriptionVersion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public ShopifySubscriptionVersion create(Long spaceId, ShopifySubscriptionCreationRequest creationRequest, Map<String, Object> params) throws IOException {
        HttpResponse response = this.createForHttpResponse(spaceId, creationRequest, params);
        String returnType = "ShopifySubscriptionVersion";
        if (returnType.equals("String")) {
            return (ShopifySubscriptionVersion)((Object)response.parseAsString());
        }
        TypeReference<ShopifySubscriptionVersion> typeRef = new TypeReference<ShopifySubscriptionVersion>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ShopifySubscriptionVersion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse createForHttpResponse(Long spaceId, ShopifySubscriptionCreationRequest creationRequest) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling create");
        }
        if (creationRequest == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creationRequest' when calling create");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/create");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, creationRequest);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse createForHttpResponse(Long spaceId, InputStream creationRequest, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling create");
        }
        if (creationRequest == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creationRequest' when calling create");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/create");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        if (creationRequest == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, creationRequest);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse createForHttpResponse(Long spaceId, ShopifySubscriptionCreationRequest creationRequest, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling create");
        }
        if (creationRequest == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creationRequest' when calling create");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/create");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, creationRequest);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public ShopifySubscription read(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id);
        String returnType = "ShopifySubscription";
        if (returnType.equals("String")) {
            return (ShopifySubscription)((Object)response.parseAsString());
        }
        TypeReference<ShopifySubscription> typeRef = new TypeReference<ShopifySubscription>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ShopifySubscription)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public ShopifySubscription read(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id, params);
        String returnType = "ShopifySubscription";
        if (returnType.equals("String")) {
            return (ShopifySubscription)((Object)response.parseAsString());
        }
        TypeReference<ShopifySubscription> typeRef = new TypeReference<ShopifySubscription>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ShopifySubscription)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/read");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/read");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public List<ShopifySubscription> search(Long spaceId, EntityQuery query) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query);
        String returnType = "List&lt;ShopifySubscription&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<ShopifySubscription>> typeRef = new TypeReference<List<ShopifySubscription>>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public List<ShopifySubscription> search(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query, params);
        String returnType = "List&lt;ShopifySubscription&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<ShopifySubscription>> typeRef = new TypeReference<List<ShopifySubscription>>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/search");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, InputStream query, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/search");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        if (query == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, query);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/search");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public void terminate(Long spaceId, Long subscriptionId, Boolean respectTerminationPeriod) throws IOException {
        this.terminateForHttpResponse(spaceId, subscriptionId, respectTerminationPeriod);
    }

    public void terminate(Long spaceId, Long subscriptionId, Boolean respectTerminationPeriod, Map<String, Object> params) throws IOException {
        this.terminateForHttpResponse(spaceId, subscriptionId, respectTerminationPeriod, params);
    }

    public HttpResponse terminateForHttpResponse(Long spaceId, Long subscriptionId, Boolean respectTerminationPeriod) throws IOException {
        Constable value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling terminate");
        }
        if (subscriptionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'subscriptionId' when calling terminate");
        }
        if (respectTerminationPeriod == null) {
            throw new IllegalArgumentException("Missing the required parameter 'respectTerminationPeriod' when calling terminate");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/terminate");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (subscriptionId != null) {
            key = "subscriptionId";
            value = subscriptionId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (respectTerminationPeriod != null) {
            key = "respectTerminationPeriod";
            value = respectTerminationPeriod;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse terminateForHttpResponse(Long spaceId, Long subscriptionId, Boolean respectTerminationPeriod, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling terminate");
        }
        if (subscriptionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'subscriptionId' when calling terminate");
        }
        if (respectTerminationPeriod == null) {
            throw new IllegalArgumentException("Missing the required parameter 'respectTerminationPeriod' when calling terminate");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/terminate");
        HashMap<String, Constable> allParams = params == null ? new HashMap<String, Constable>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("subscriptionId", subscriptionId);
        allParams.put("respectTerminationPeriod", respectTerminationPeriod);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public ShopifySubscriptionVersion update(Long spaceId, ShopifySubscriptionUpdateRequest subscription) throws IOException {
        HttpResponse response = this.updateForHttpResponse(spaceId, subscription);
        String returnType = "ShopifySubscriptionVersion";
        if (returnType.equals("String")) {
            return (ShopifySubscriptionVersion)((Object)response.parseAsString());
        }
        TypeReference<ShopifySubscriptionVersion> typeRef = new TypeReference<ShopifySubscriptionVersion>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ShopifySubscriptionVersion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public ShopifySubscriptionVersion update(Long spaceId, ShopifySubscriptionUpdateRequest subscription, Map<String, Object> params) throws IOException {
        HttpResponse response = this.updateForHttpResponse(spaceId, subscription, params);
        String returnType = "ShopifySubscriptionVersion";
        if (returnType.equals("String")) {
            return (ShopifySubscriptionVersion)((Object)response.parseAsString());
        }
        TypeReference<ShopifySubscriptionVersion> typeRef = new TypeReference<ShopifySubscriptionVersion>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ShopifySubscriptionVersion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse updateForHttpResponse(Long spaceId, ShopifySubscriptionUpdateRequest subscription) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling update");
        }
        if (subscription == null) {
            throw new IllegalArgumentException("Missing the required parameter 'subscription' when calling update");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/update");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, subscription);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse updateForHttpResponse(Long spaceId, InputStream subscription, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling update");
        }
        if (subscription == null) {
            throw new IllegalArgumentException("Missing the required parameter 'subscription' when calling update");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/update");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        if (subscription == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, subscription);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse updateForHttpResponse(Long spaceId, ShopifySubscriptionUpdateRequest subscription, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling update");
        }
        if (subscription == null) {
            throw new IllegalArgumentException("Missing the required parameter 'subscription' when calling update");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/update");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, subscription);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public ShopifySubscriptionVersion updateAddresses(Long spaceId, ShopifySubscriptionUpdateAddressesRequest updateRequest) throws IOException {
        HttpResponse response = this.updateAddressesForHttpResponse(spaceId, updateRequest);
        String returnType = "ShopifySubscriptionVersion";
        if (returnType.equals("String")) {
            return (ShopifySubscriptionVersion)((Object)response.parseAsString());
        }
        TypeReference<ShopifySubscriptionVersion> typeRef = new TypeReference<ShopifySubscriptionVersion>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ShopifySubscriptionVersion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public ShopifySubscriptionVersion updateAddresses(Long spaceId, ShopifySubscriptionUpdateAddressesRequest updateRequest, Map<String, Object> params) throws IOException {
        HttpResponse response = this.updateAddressesForHttpResponse(spaceId, updateRequest, params);
        String returnType = "ShopifySubscriptionVersion";
        if (returnType.equals("String")) {
            return (ShopifySubscriptionVersion)((Object)response.parseAsString());
        }
        TypeReference<ShopifySubscriptionVersion> typeRef = new TypeReference<ShopifySubscriptionVersion>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ShopifySubscriptionVersion)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse updateAddressesForHttpResponse(Long spaceId, ShopifySubscriptionUpdateAddressesRequest updateRequest) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling updateAddresses");
        }
        if (updateRequest == null) {
            throw new IllegalArgumentException("Missing the required parameter 'updateRequest' when calling updateAddresses");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/update-addresses");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, updateRequest);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse updateAddressesForHttpResponse(Long spaceId, InputStream updateRequest, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling updateAddresses");
        }
        if (updateRequest == null) {
            throw new IllegalArgumentException("Missing the required parameter 'updateRequest' when calling updateAddresses");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/update-addresses");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        if (updateRequest == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, updateRequest);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse updateAddressesForHttpResponse(Long spaceId, ShopifySubscriptionUpdateAddressesRequest updateRequest, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling updateAddresses");
        }
        if (updateRequest == null) {
            throw new IllegalArgumentException("Missing the required parameter 'updateRequest' when calling updateAddresses");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/shopify-subscription/update-addresses");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, updateRequest);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    private boolean isNoBodyResponse(HttpResponse response) throws IOException {
        InputStream content = response.getContent();
        return content.available() == 0;
    }
}

