/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.ErrorCode;
import ch.postfinance.sdk.exception.PostFinanceCheckoutSdkException;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.util.URIBuilderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

public class PaymentTerminalTillService {
    private ApiClient apiClient;

    public PaymentTerminalTillService(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public Transaction performTransaction(Long spaceId, Long transactionId, Long terminalId, String language) throws IOException {
        HttpResponse response = this.performTransactionForHttpResponse(spaceId, transactionId, terminalId, language);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Transaction performTransaction(Long spaceId, Long transactionId, Long terminalId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.performTransactionForHttpResponse(spaceId, transactionId, terminalId, params);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse performTransactionForHttpResponse(Long spaceId, Long transactionId, Long terminalId, String language) throws IOException {
        Object value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling performTransaction");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling performTransaction");
        }
        if (terminalId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'terminalId' when calling performTransaction");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/payment-terminal-till/perform-transaction");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (transactionId != null) {
            key = "transactionId";
            value = transactionId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (terminalId != null) {
            key = "terminalId";
            value = terminalId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (language != null) {
            key = "language";
            value = language;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = 90000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse performTransactionForHttpResponse(Long spaceId, Long transactionId, Long terminalId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling performTransaction");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling performTransaction");
        }
        if (terminalId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'terminalId' when calling performTransaction");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/payment-terminal-till/perform-transaction");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("transactionId", transactionId);
        allParams.put("terminalId", terminalId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = 90000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public Transaction performTransactionByIdentifier(Long spaceId, Long transactionId, String terminalIdentifier, String language) throws IOException {
        HttpResponse response = this.performTransactionByIdentifierForHttpResponse(spaceId, transactionId, terminalIdentifier, language);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Transaction performTransactionByIdentifier(Long spaceId, Long transactionId, String terminalIdentifier, Map<String, Object> params) throws IOException {
        HttpResponse response = this.performTransactionByIdentifierForHttpResponse(spaceId, transactionId, terminalIdentifier, params);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse performTransactionByIdentifierForHttpResponse(Long spaceId, Long transactionId, String terminalIdentifier, String language) throws IOException {
        Object value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling performTransactionByIdentifier");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling performTransactionByIdentifier");
        }
        if (terminalIdentifier == null) {
            throw new IllegalArgumentException("Missing the required parameter 'terminalIdentifier' when calling performTransactionByIdentifier");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/payment-terminal-till/perform-transaction-by-identifier");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (transactionId != null) {
            key = "transactionId";
            value = transactionId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (terminalIdentifier != null) {
            key = "terminalIdentifier";
            value = terminalIdentifier;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (language != null) {
            key = "language";
            value = language;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = 90000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse performTransactionByIdentifierForHttpResponse(Long spaceId, Long transactionId, String terminalIdentifier, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling performTransactionByIdentifier");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling performTransactionByIdentifier");
        }
        if (terminalIdentifier == null) {
            throw new IllegalArgumentException("Missing the required parameter 'terminalIdentifier' when calling performTransactionByIdentifier");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/payment-terminal-till/perform-transaction-by-identifier");
        HashMap<String, Object> allParams = params == null ? new HashMap<String, Object>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("transactionId", transactionId);
        allParams.put("terminalIdentifier", terminalIdentifier);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = 90000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    private boolean isNoBodyResponse(HttpResponse response) throws IOException {
        InputStream content = response.getContent();
        return content.available() == 0;
    }
}

