/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.ErrorCode;
import ch.postfinance.sdk.exception.PostFinanceCheckoutSdkException;
import ch.postfinance.sdk.model.ChargeFlow;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.util.URIBuilderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

public class ChargeFlowService {
    private ApiClient apiClient;

    public ChargeFlowService(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must be non null");
    }

    public Transaction applyFlow(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.applyFlowForHttpResponse(spaceId, id);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Transaction applyFlow(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.applyFlowForHttpResponse(spaceId, id, params);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse applyFlowForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling applyFlow");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling applyFlow");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/applyFlow");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse applyFlowForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling applyFlow");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling applyFlow");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/applyFlow");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public Transaction cancelChargeFlow(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.cancelChargeFlowForHttpResponse(spaceId, id);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Transaction cancelChargeFlow(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.cancelChargeFlowForHttpResponse(spaceId, id, params);
        String returnType = "Transaction";
        if (returnType.equals("String")) {
            return (Transaction)((Object)response.parseAsString());
        }
        TypeReference<Transaction> typeRef = new TypeReference<Transaction>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Transaction)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse cancelChargeFlowForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling cancelChargeFlow");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling cancelChargeFlow");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/cancel-charge-flow");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse cancelChargeFlowForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling cancelChargeFlow");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling cancelChargeFlow");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/cancel-charge-flow");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public Long count(Long spaceId, EntityQueryFilter filter) throws IOException {
        HttpResponse response = this.countForHttpResponse(spaceId, filter);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Long count(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.countForHttpResponse(filter, spaceId, params);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse countForHttpResponse(Long spaceId, EntityQueryFilter filter) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/count");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(Long spaceId, InputStream filter, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/count");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        if (filter == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, filter);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/count");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public String fetchChargeFlowPaymentPageUrl(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.fetchChargeFlowPaymentPageUrlForHttpResponse(spaceId, id);
        String returnType = "String";
        if (returnType.equals("String")) {
            return response.parseAsString();
        }
        TypeReference<String> typeRef = new TypeReference<String>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (String)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public String fetchChargeFlowPaymentPageUrl(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.fetchChargeFlowPaymentPageUrlForHttpResponse(spaceId, id, params);
        String returnType = "String";
        if (returnType.equals("String")) {
            return response.parseAsString();
        }
        TypeReference<String> typeRef = new TypeReference<String>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (String)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse fetchChargeFlowPaymentPageUrlForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling fetchChargeFlowPaymentPageUrl");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling fetchChargeFlowPaymentPageUrl");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/fetch-charge-flow-payment-page-url");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse fetchChargeFlowPaymentPageUrlForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling fetchChargeFlowPaymentPageUrl");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling fetchChargeFlowPaymentPageUrl");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/fetch-charge-flow-payment-page-url");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public ChargeFlow read(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id);
        String returnType = "ChargeFlow";
        if (returnType.equals("String")) {
            return (ChargeFlow)((Object)response.parseAsString());
        }
        TypeReference<ChargeFlow> typeRef = new TypeReference<ChargeFlow>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ChargeFlow)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public ChargeFlow read(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id, params);
        String returnType = "ChargeFlow";
        if (returnType.equals("String")) {
            return (ChargeFlow)((Object)response.parseAsString());
        }
        TypeReference<ChargeFlow> typeRef = new TypeReference<ChargeFlow>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (ChargeFlow)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/read");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/read");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public List<ChargeFlow> search(Long spaceId, EntityQuery query) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query);
        String returnType = "List&lt;ChargeFlow&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<ChargeFlow>> typeRef = new TypeReference<List<ChargeFlow>>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public List<ChargeFlow> search(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query, params);
        String returnType = "List&lt;ChargeFlow&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<ChargeFlow>> typeRef = new TypeReference<List<ChargeFlow>>(){};
        if (this.isNoBodyResponse(response)) {
            throw new PostFinanceCheckoutSdkException(ErrorCode.ENTITY_NOT_FOUND, "Entity was not found for: " + typeRef.getType().getTypeName());
        }
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/search");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, InputStream query, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/search");
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        if (query == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, query);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/search");
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public void updateRecipient(Long spaceId, Long transactionId, Long type, String recipient) throws IOException {
        this.updateRecipientForHttpResponse(spaceId, transactionId, type, recipient);
    }

    public void updateRecipient(Long spaceId, Long transactionId, Long type, String recipient, Map<String, Object> params) throws IOException {
        this.updateRecipientForHttpResponse(spaceId, transactionId, type, recipient, params);
    }

    public HttpResponse updateRecipientForHttpResponse(Long spaceId, Long transactionId, Long type, String recipient) throws IOException {
        Object value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling updateRecipient");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling updateRecipient");
        }
        if (type == null) {
            throw new IllegalArgumentException("Missing the required parameter 'type' when calling updateRecipient");
        }
        if (recipient == null) {
            throw new IllegalArgumentException("Missing the required parameter 'recipient' when calling updateRecipient");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/updateRecipient");
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (transactionId != null) {
            key = "transactionId";
            value = transactionId;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (type != null) {
            key = "type";
            value = type;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        if (recipient != null) {
            key = "recipient";
            value = recipient;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    public HttpResponse updateRecipientForHttpResponse(Long spaceId, Long transactionId, Long type, String recipient, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling updateRecipient");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'transactionId' when calling updateRecipient");
        }
        if (type == null) {
            throw new IllegalArgumentException("Missing the required parameter 'type' when calling updateRecipient");
        }
        if (recipient == null) {
            throw new IllegalArgumentException("Missing the required parameter 'recipient' when calling updateRecipient");
        }
        URIBuilder uriBuilder = URIBuilderUtil.create(this.apiClient.getBasePath() + "/charge-flow/updateRecipient");
        HashMap<String, Object> allParams = params == null ? new HashMap<String, Object>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("transactionId", transactionId);
        allParams.put("type", type);
        allParams.put("recipient", recipient);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            uriBuilder = URIBuilderUtil.applyQueryParam(uriBuilder, key, value);
        }
        GenericUrl genericUrl = new GenericUrl(URIBuilderUtil.build(uriBuilder));
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        int readTimeOut = this.apiClient.getReadTimeOut() * 1000;
        httpRequest.setReadTimeout(readTimeOut);
        return httpRequest.execute();
    }

    private boolean isNoBodyResponse(HttpResponse response) throws IOException {
        InputStream content = response.getContent();
        return content.available() == 0;
    }
}

