/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class WebhookUrl {
    @JsonProperty(value="applicationManaged")
    protected Boolean applicationManaged = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="url")
    protected String url = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="Whether the webhook URL is managed by the application, and therefore cannot be changed via the user interface.")
    public Boolean isApplicationManaged() {
        return this.applicationManaged;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The name used to identify the webhook URL.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The actual URL where notifications about entity changes are sent to.")
    public String getUrl() {
        return this.url;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookUrl webhookUrl = (WebhookUrl)o;
        return Objects.equals(this.applicationManaged, webhookUrl.applicationManaged) && Objects.equals(this.id, webhookUrl.id) && Objects.equals(this.linkedSpaceId, webhookUrl.linkedSpaceId) && Objects.equals(this.name, webhookUrl.name) && Objects.equals(this.plannedPurgeDate, webhookUrl.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)webhookUrl.state) && Objects.equals(this.url, webhookUrl.url) && Objects.equals(this.version, webhookUrl.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationManaged, this.id, this.linkedSpaceId, this.name, this.plannedPurgeDate, this.state, this.url, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookUrl {\n");
        sb.append("    applicationManaged: ").append(this.toIndentedString(this.applicationManaged)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

