/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.WebhookIdentity;
import ch.postfinance.sdk.model.WebhookUrl;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class WebhookListener {
    @JsonProperty(value="enablePayloadSignatureAndState")
    protected Boolean enablePayloadSignatureAndState = null;
    @JsonProperty(value="entity")
    protected Long entity = null;
    @JsonProperty(value="entityStates")
    protected List<String> entityStates = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="identity")
    protected WebhookIdentity identity = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="notifyEveryChange")
    protected Boolean notifyEveryChange = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="url")
    protected WebhookUrl url = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="Whether signature header and 'state' property are enabled in webhook payload.")
    public Boolean isEnablePayloadSignatureAndState() {
        return this.enablePayloadSignatureAndState;
    }

    @ApiModelProperty(value="The entity that is to be monitored.")
    public Long getEntity() {
        return this.entity;
    }

    @ApiModelProperty(value="The entity's target states that are to be monitored.")
    public List<String> getEntityStates() {
        return this.entityStates;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The identity used to sign messages.")
    public WebhookIdentity getIdentity() {
        return this.identity;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The name used to identify the webhook listener.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="Whether every update of the entity or only state changes are to be monitored.")
    public Boolean isNotifyEveryChange() {
        return this.notifyEveryChange;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The URL where notifications about entity changes are sent to.")
    public WebhookUrl getUrl() {
        return this.url;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookListener webhookListener = (WebhookListener)o;
        return Objects.equals(this.enablePayloadSignatureAndState, webhookListener.enablePayloadSignatureAndState) && Objects.equals(this.entity, webhookListener.entity) && Objects.equals(this.entityStates, webhookListener.entityStates) && Objects.equals(this.id, webhookListener.id) && Objects.equals(this.identity, webhookListener.identity) && Objects.equals(this.linkedSpaceId, webhookListener.linkedSpaceId) && Objects.equals(this.name, webhookListener.name) && Objects.equals(this.notifyEveryChange, webhookListener.notifyEveryChange) && Objects.equals(this.plannedPurgeDate, webhookListener.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)webhookListener.state) && Objects.equals(this.url, webhookListener.url) && Objects.equals(this.version, webhookListener.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enablePayloadSignatureAndState, this.entity, this.entityStates, this.id, this.identity, this.linkedSpaceId, this.name, this.notifyEveryChange, this.plannedPurgeDate, this.state, this.url, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookListener {\n");
        sb.append("    enablePayloadSignatureAndState: ").append(this.toIndentedString(this.enablePayloadSignatureAndState)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    entityStates: ").append(this.toIndentedString(this.entityStates)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notifyEveryChange: ").append(this.toIndentedString(this.notifyEveryChange)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

