/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Space;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The confirmation response provides details about the installation of the web app.")
public class WebAppConfirmationResponse {
    @JsonProperty(value="access_token")
    protected String accessToken = null;
    @JsonProperty(value="scope")
    protected String scope = null;
    @JsonProperty(value="space")
    protected Space space = null;
    @JsonProperty(value="state")
    protected String state = null;
    @JsonProperty(value="token_type")
    protected String tokenType = null;

    @ApiModelProperty(value="The access code granting permissions to the web service API according to the OAuth standard.")
    public String getAccessToken() {
        return this.accessToken;
    }

    @ApiModelProperty(value="The list of the permissions granted to the web app within the space.")
    public String getScope() {
        return this.scope;
    }

    @ApiModelProperty(value="The space that the web app was installed in.")
    public Space getSpace() {
        return this.space;
    }

    @ApiModelProperty(value="The state parameter that was provided in the authorization request.")
    public String getState() {
        return this.state;
    }

    @ApiModelProperty(value="The type of the access token that determines the authentication mechanism to use for accessing the web service API.")
    public String getTokenType() {
        return this.tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAppConfirmationResponse webAppConfirmationResponse = (WebAppConfirmationResponse)o;
        return Objects.equals(this.accessToken, webAppConfirmationResponse.accessToken) && Objects.equals(this.scope, webAppConfirmationResponse.scope) && Objects.equals(this.space, webAppConfirmationResponse.space) && Objects.equals(this.state, webAppConfirmationResponse.state) && Objects.equals(this.tokenType, webAppConfirmationResponse.tokenType);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.scope, this.space, this.state, this.tokenType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAppConfirmationResponse {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    space: ").append(this.toIndentedString(this.space)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

