/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Address;
import ch.postfinance.sdk.model.Environment;
import ch.postfinance.sdk.model.LineItem;
import ch.postfinance.sdk.model.TransactionAwareEntity;
import ch.postfinance.sdk.model.TransactionCompletion;
import ch.postfinance.sdk.model.TransactionInvoiceState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The transaction invoice represents the invoice document for a particular transaction.")
public class TransactionInvoice
extends TransactionAwareEntity {
    @JsonProperty(value="amount")
    protected BigDecimal amount = null;
    @JsonProperty(value="billingAddress")
    protected Address billingAddress = null;
    @JsonProperty(value="completion")
    protected TransactionCompletion completion = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="derecognizedBy")
    protected Long derecognizedBy = null;
    @JsonProperty(value="derecognizedOn")
    protected OffsetDateTime derecognizedOn = null;
    @JsonProperty(value="dueOn")
    protected OffsetDateTime dueOn = null;
    @JsonProperty(value="environment")
    protected Environment environment = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="lineItems")
    protected List<LineItem> lineItems = null;
    @JsonProperty(value="merchantReference")
    protected String merchantReference = null;
    @JsonProperty(value="outstandingAmount")
    protected BigDecimal outstandingAmount = null;
    @JsonProperty(value="paidOn")
    protected OffsetDateTime paidOn = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="spaceViewId")
    protected Long spaceViewId = null;
    @JsonProperty(value="state")
    protected TransactionInvoiceState state = null;
    @JsonProperty(value="taxAmount")
    protected BigDecimal taxAmount = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @ApiModelProperty(value="")
    public TransactionCompletion getCompletion() {
        return this.completion;
    }

    @ApiModelProperty(value="The date on which the invoice is created on.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The id of the user which marked the invoice as derecognized.")
    public Long getDerecognizedBy() {
        return this.derecognizedBy;
    }

    @ApiModelProperty(value="The date on which the invoice is marked as derecognized.")
    public OffsetDateTime getDerecognizedOn() {
        return this.derecognizedOn;
    }

    @ApiModelProperty(value="The date on which the invoice should be paid on.")
    public OffsetDateTime getDueOn() {
        return this.dueOn;
    }

    @ApiModelProperty(value="")
    public Environment getEnvironment() {
        return this.environment;
    }

    @ApiModelProperty(value="The external id helps to identify the entity and a subsequent creation of an entity with the same ID will not create a new entity.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="The language that is linked to the object.")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @ApiModelProperty(value="")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @ApiModelProperty(value="The outstanding amount indicates how much the buyer owes the merchant. A negative amount indicates that the invoice is overpaid.")
    public BigDecimal getOutstandingAmount() {
        return this.outstandingAmount;
    }

    @ApiModelProperty(value="The date on which the invoice is marked as paid. Eventually this date lags behind of the actual paid date.")
    public OffsetDateTime getPaidOn() {
        return this.paidOn;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The ID of the space view this object is linked to.")
    public Long getSpaceViewId() {
        return this.spaceViewId;
    }

    @ApiModelProperty(value="The object's current state.")
    public TransactionInvoiceState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    @ApiModelProperty(value="")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInvoice transactionInvoice = (TransactionInvoice)o;
        return Objects.equals(this.id, transactionInvoice.id) && Objects.equals(this.linkedSpaceId, transactionInvoice.linkedSpaceId) && Objects.equals(this.linkedTransaction, transactionInvoice.linkedTransaction) && Objects.equals(this.amount, transactionInvoice.amount) && Objects.equals(this.billingAddress, transactionInvoice.billingAddress) && Objects.equals(this.completion, transactionInvoice.completion) && Objects.equals(this.createdOn, transactionInvoice.createdOn) && Objects.equals(this.derecognizedBy, transactionInvoice.derecognizedBy) && Objects.equals(this.derecognizedOn, transactionInvoice.derecognizedOn) && Objects.equals(this.dueOn, transactionInvoice.dueOn) && Objects.equals((Object)this.environment, (Object)transactionInvoice.environment) && Objects.equals(this.externalId, transactionInvoice.externalId) && Objects.equals(this.language, transactionInvoice.language) && Objects.equals(this.lineItems, transactionInvoice.lineItems) && Objects.equals(this.merchantReference, transactionInvoice.merchantReference) && Objects.equals(this.outstandingAmount, transactionInvoice.outstandingAmount) && Objects.equals(this.paidOn, transactionInvoice.paidOn) && Objects.equals(this.plannedPurgeDate, transactionInvoice.plannedPurgeDate) && Objects.equals(this.spaceViewId, transactionInvoice.spaceViewId) && Objects.equals((Object)this.state, (Object)transactionInvoice.state) && Objects.equals(this.taxAmount, transactionInvoice.taxAmount) && Objects.equals(this.timeZone, transactionInvoice.timeZone) && Objects.equals(this.version, transactionInvoice.version) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.linkedSpaceId, this.linkedTransaction, this.amount, this.billingAddress, this.completion, this.createdOn, this.derecognizedBy, this.derecognizedOn, this.dueOn, this.environment, this.externalId, this.language, this.lineItems, this.merchantReference, this.outstandingAmount, this.paidOn, this.plannedPurgeDate, this.spaceViewId, this.state, this.taxAmount, this.timeZone, this.version, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionInvoice {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    linkedTransaction: ").append(this.toIndentedString(this.linkedTransaction)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    completion: ").append(this.toIndentedString(this.completion)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    derecognizedBy: ").append(this.toIndentedString(this.derecognizedBy)).append("\n");
        sb.append("    derecognizedOn: ").append(this.toIndentedString(this.derecognizedOn)).append("\n");
        sb.append("    dueOn: ").append(this.toIndentedString(this.dueOn)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    outstandingAmount: ").append(this.toIndentedString(this.outstandingAmount)).append("\n");
        sb.append("    paidOn: ").append(this.toIndentedString(this.paidOn)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    spaceViewId: ").append(this.toIndentedString(this.spaceViewId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

