/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.AbstractTransactionPending;
import ch.postfinance.sdk.model.CustomersPresence;
import ch.postfinance.sdk.model.Environment;
import ch.postfinance.sdk.model.TransactionEnvironmentSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class TransactionCreate
extends AbstractTransactionPending {
    @JsonProperty(value="autoConfirmationEnabled")
    protected Boolean autoConfirmationEnabled = null;
    @JsonProperty(value="chargeRetryEnabled")
    protected Boolean chargeRetryEnabled = null;
    @JsonProperty(value="customersPresence")
    protected CustomersPresence customersPresence = null;
    @JsonProperty(value="deviceSessionIdentifier")
    protected String deviceSessionIdentifier = null;
    @JsonProperty(value="emailsDisabled")
    protected Boolean emailsDisabled = null;
    @JsonProperty(value="environment")
    protected Environment environment = null;
    @JsonProperty(value="environmentSelectionStrategy")
    protected TransactionEnvironmentSelectionStrategy environmentSelectionStrategy = null;
    @JsonProperty(value="spaceViewId")
    protected Long spaceViewId = null;

    public TransactionCreate autoConfirmationEnabled(Boolean autoConfirmationEnabled) {
        this.autoConfirmationEnabled = autoConfirmationEnabled;
        return this;
    }

    @ApiModelProperty(value="Whether the transaction can be confirmed automatically or whether this must be done explicitly via the API. Default is true.")
    public Boolean isAutoConfirmationEnabled() {
        return this.autoConfirmationEnabled;
    }

    public void setAutoConfirmationEnabled(Boolean autoConfirmationEnabled) {
        this.autoConfirmationEnabled = autoConfirmationEnabled;
    }

    public TransactionCreate chargeRetryEnabled(Boolean chargeRetryEnabled) {
        this.chargeRetryEnabled = chargeRetryEnabled;
        return this;
    }

    @ApiModelProperty(value="Whether the customer can make further payment attempts if the first one has failed. Default is true.")
    public Boolean isChargeRetryEnabled() {
        return this.chargeRetryEnabled;
    }

    public void setChargeRetryEnabled(Boolean chargeRetryEnabled) {
        this.chargeRetryEnabled = chargeRetryEnabled;
    }

    public TransactionCreate customersPresence(CustomersPresence customersPresence) {
        this.customersPresence = customersPresence;
        return this;
    }

    @ApiModelProperty(value="The customer's presence indicates whether and in what way the transaction's customer is present. Default is VIRTUAL_PRESENT.")
    public CustomersPresence getCustomersPresence() {
        return this.customersPresence;
    }

    public void setCustomersPresence(CustomersPresence customersPresence) {
        this.customersPresence = customersPresence;
    }

    public TransactionCreate deviceSessionIdentifier(String deviceSessionIdentifier) {
        this.deviceSessionIdentifier = deviceSessionIdentifier;
        return this;
    }

    @ApiModelProperty(value="Allows to link the transaction to the data collected from the customer's device.")
    public String getDeviceSessionIdentifier() {
        return this.deviceSessionIdentifier;
    }

    public void setDeviceSessionIdentifier(String deviceSessionIdentifier) {
        this.deviceSessionIdentifier = deviceSessionIdentifier;
    }

    public TransactionCreate emailsDisabled(Boolean emailsDisabled) {
        this.emailsDisabled = emailsDisabled;
        return this;
    }

    @ApiModelProperty(value="Whether email sending is deactivated for the transaction. Default is false.")
    public Boolean isEmailsDisabled() {
        return this.emailsDisabled;
    }

    public void setEmailsDisabled(Boolean emailsDisabled) {
        this.emailsDisabled = emailsDisabled;
    }

    public TransactionCreate environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(value="")
    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public TransactionCreate environmentSelectionStrategy(TransactionEnvironmentSelectionStrategy environmentSelectionStrategy) {
        this.environmentSelectionStrategy = environmentSelectionStrategy;
        return this;
    }

    @ApiModelProperty(value="The strategy for determining whether the transaction is to be processed in the test or production environment.")
    public TransactionEnvironmentSelectionStrategy getEnvironmentSelectionStrategy() {
        return this.environmentSelectionStrategy;
    }

    public void setEnvironmentSelectionStrategy(TransactionEnvironmentSelectionStrategy environmentSelectionStrategy) {
        this.environmentSelectionStrategy = environmentSelectionStrategy;
    }

    public TransactionCreate spaceViewId(Long spaceViewId) {
        this.spaceViewId = spaceViewId;
        return this;
    }

    @ApiModelProperty(value="The ID of the space view this object is linked to.")
    public Long getSpaceViewId() {
        return this.spaceViewId;
    }

    public void setSpaceViewId(Long spaceViewId) {
        this.spaceViewId = spaceViewId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionCreate transactionCreate = (TransactionCreate)o;
        return Objects.equals(this.allowedPaymentMethodBrands, transactionCreate.allowedPaymentMethodBrands) && Objects.equals(this.allowedPaymentMethodConfigurations, transactionCreate.allowedPaymentMethodConfigurations) && Objects.equals(this.billingAddress, transactionCreate.billingAddress) && Objects.equals((Object)this.completionBehavior, (Object)transactionCreate.completionBehavior) && Objects.equals(this.currency, transactionCreate.currency) && Objects.equals(this.customerEmailAddress, transactionCreate.customerEmailAddress) && Objects.equals(this.customerId, transactionCreate.customerId) && Objects.equals(this.failedUrl, transactionCreate.failedUrl) && Objects.equals(this.invoiceMerchantReference, transactionCreate.invoiceMerchantReference) && Objects.equals(this.language, transactionCreate.language) && Objects.equals(this.lineItems, transactionCreate.lineItems) && Objects.equals(this.merchantReference, transactionCreate.merchantReference) && Objects.equals(this.metaData, transactionCreate.metaData) && Objects.equals(this.shippingAddress, transactionCreate.shippingAddress) && Objects.equals(this.shippingMethod, transactionCreate.shippingMethod) && Objects.equals(this.successUrl, transactionCreate.successUrl) && Objects.equals(this.timeZone, transactionCreate.timeZone) && Objects.equals(this.token, transactionCreate.token) && Objects.equals((Object)this.tokenizationMode, (Object)transactionCreate.tokenizationMode) && Objects.equals(this.autoConfirmationEnabled, transactionCreate.autoConfirmationEnabled) && Objects.equals(this.chargeRetryEnabled, transactionCreate.chargeRetryEnabled) && Objects.equals((Object)this.customersPresence, (Object)transactionCreate.customersPresence) && Objects.equals(this.deviceSessionIdentifier, transactionCreate.deviceSessionIdentifier) && Objects.equals(this.emailsDisabled, transactionCreate.emailsDisabled) && Objects.equals((Object)this.environment, (Object)transactionCreate.environment) && Objects.equals((Object)this.environmentSelectionStrategy, (Object)transactionCreate.environmentSelectionStrategy) && Objects.equals(this.spaceViewId, transactionCreate.spaceViewId) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedPaymentMethodBrands, this.allowedPaymentMethodConfigurations, this.billingAddress, this.completionBehavior, this.currency, this.customerEmailAddress, this.customerId, this.failedUrl, this.invoiceMerchantReference, this.language, this.lineItems, this.merchantReference, this.metaData, this.shippingAddress, this.shippingMethod, this.successUrl, this.timeZone, this.token, this.tokenizationMode, this.autoConfirmationEnabled, this.chargeRetryEnabled, this.customersPresence, this.deviceSessionIdentifier, this.emailsDisabled, this.environment, this.environmentSelectionStrategy, this.spaceViewId, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionCreate {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    allowedPaymentMethodBrands: ").append(this.toIndentedString(this.allowedPaymentMethodBrands)).append("\n");
        sb.append("    allowedPaymentMethodConfigurations: ").append(this.toIndentedString(this.allowedPaymentMethodConfigurations)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    completionBehavior: ").append(this.toIndentedString((Object)this.completionBehavior)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    customerEmailAddress: ").append(this.toIndentedString(this.customerEmailAddress)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    failedUrl: ").append(this.toIndentedString(this.failedUrl)).append("\n");
        sb.append("    invoiceMerchantReference: ").append(this.toIndentedString(this.invoiceMerchantReference)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    metaData: ").append(this.toIndentedString(this.metaData)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    shippingMethod: ").append(this.toIndentedString(this.shippingMethod)).append("\n");
        sb.append("    successUrl: ").append(this.toIndentedString(this.successUrl)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenizationMode: ").append(this.toIndentedString((Object)this.tokenizationMode)).append("\n");
        sb.append("    autoConfirmationEnabled: ").append(this.toIndentedString(this.autoConfirmationEnabled)).append("\n");
        sb.append("    chargeRetryEnabled: ").append(this.toIndentedString(this.chargeRetryEnabled)).append("\n");
        sb.append("    customersPresence: ").append(this.toIndentedString((Object)this.customersPresence)).append("\n");
        sb.append("    deviceSessionIdentifier: ").append(this.toIndentedString(this.deviceSessionIdentifier)).append("\n");
        sb.append("    emailsDisabled: ").append(this.toIndentedString(this.emailsDisabled)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("    environmentSelectionStrategy: ").append(this.toIndentedString((Object)this.environmentSelectionStrategy)).append("\n");
        sb.append("    spaceViewId: ").append(this.toIndentedString(this.spaceViewId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

